/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.worker;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.DeltaImportStrategy;
import org.eclipse.smila.importing.State;
import org.eclipse.smila.importing.worker.WorkerUsingDeltaService;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class DeltaCheckerWorker
extends WorkerUsingDeltaService {
    private static final String WORKER_NAME = "deltaChecker";
    private static final String INPUT_SLOT_NAME = "recordsToCheck";
    private static final String OUTPUT_SLOT_RECORDS = "updatedRecords";
    private static final String OUTPUT_SLOT_COMPOUNDS = "updatedCompounds";
    private final Log _log = LogFactory.getLog(this.getClass());

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        String jobRunId = this.getJobRunId(taskContext);
        Inputs inputs = taskContext.getInputs();
        RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
        Outputs outputs = taskContext.getOutputs();
        RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_RECORDS);
        boolean hasCompoundOutput = outputs.getDataObjectCount(OUTPUT_SLOT_COMPOUNDS) > 0;
        int compoundBulkCount = 0;
        DeltaImportStrategy deltaStrategy = this.getDeltaImportStrategy(taskContext);
        Record record = recordInput.getRecord();
        while (record != null && !taskContext.isCanceled()) {
            Record updatedRecord = this.checkRecord(taskContext, jobRunId, record, deltaStrategy);
            if (updatedRecord != null) {
                if (hasCompoundOutput && this.isCompound(updatedRecord)) {
                    RecordOutput compoundOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_COMPOUNDS, compoundBulkCount);
                    compoundOutput.writeRecord(updatedRecord);
                    compoundOutput.commit();
                    ++compoundBulkCount;
                } else {
                    recordOutput.writeRecord(updatedRecord);
                }
            }
            record = recordInput.getRecord();
        }
    }

    private Record checkRecord(TaskContext taskContext, String jobRunId, Record record, DeltaImportStrategy deltaStrategy) throws DeltaException, ObjectStoreException, IOException {
        if (deltaStrategy.isDeltaCheckDisabled()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Delta checking is disabled, record " + record.getId() + " is added to output."));
            }
            return record;
        }
        String deltaHash = record.getMetadata().getStringValue("_deltaHash");
        if (deltaHash == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Record " + record.getId() + " has no hash attribute value, is added to output."));
            }
            return record;
        }
        State deltaStatus = this.checkDeltaStateTimed(jobRunId, record, deltaHash, taskContext);
        if (deltaStatus == State.UPTODATE) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Record " + record.getId() + " is up to date"));
            }
            if (this.isCompound(record)) {
                this.markCompoundElementsVisitedTimed(jobRunId, record, taskContext);
            }
            return null;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Record " + record.getId() + " will be added to output, has status " + (Object)((Object)deltaStatus)));
        }
        return record;
    }
}

