/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.params.HttpParams;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.http.client.Attachments;
import org.eclipse.smila.http.client.HttpMethod;
import org.eclipse.smila.http.client.impl.base.HttpRequestFactory;

public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    private static final String PARTNAME_RECORD = "_record";
    private final IpcAnyWriter _jsonWriter = new IpcAnyWriter(false);

    @Override
    public HttpUriRequest getHttpMethod(HttpMethod method, String url) {
        switch (method) {
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                return new HttpPost(url);
            }
            case PUT: {
                return new HttpPut(url);
            }
            case DELETE: {
                return new HttpDelete(url);
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP method " + method.name());
    }

    @Override
    public HttpUriRequest getHttpMethod(HttpMethod method, String url, HttpParams methodParams) {
        HttpUriRequest httpMethod = this.getHttpMethod(method, url);
        if (methodParams != null) {
            httpMethod.setParams(methodParams);
        }
        return httpMethod;
    }

    @Override
    public HttpEntity createJsonEntity(Any parameters) throws IOException {
        if (parameters == null) {
            return null;
        }
        String jsonParameters = this._jsonWriter.writeJsonObject(parameters);
        return new StringEntity(jsonParameters, "application/json", "UTF-8");
    }

    @Override
    public HttpEntity createJsonEntity(InputStream inputStream) throws IOException {
        return this.createEntity(inputStream, "application/json; charset=UTF-8");
    }

    @Override
    public HttpEntity createEntity(InputStream inputStream, String contentType) throws IOException {
        if (inputStream == null) {
            return null;
        }
        InputStreamEntity entity = new InputStreamEntity(inputStream, -1L);
        entity.setContentType(contentType);
        return entity;
    }

    @Override
    public HttpEntity createHttpEntity(Any parameters, Attachments attachments) throws IOException {
        HttpEntity requestEntity = attachments == null ? this.createJsonEntity(parameters) : this.createMultipartEntity(parameters, attachments);
        return requestEntity;
    }

    @Override
    public HttpEntity createMultipartEntity(Any parameters, Attachments attachments) throws IOException {
        MultipartEntity requestEntity = new MultipartEntity(HttpMultipartMode.STRICT);
        String jsonParameters = parameters == null ? "{}" : this._jsonWriter.writeJsonObject(parameters);
        StringBody jsonBody = new StringBody(jsonParameters, "application/json", CHARSET);
        requestEntity.addPart(PARTNAME_RECORD, (ContentBody)jsonBody);
        for (Map.Entry<String, ContentBody> attachmentPart : attachments.getAttachmentParts().entrySet()) {
            requestEntity.addPart(attachmentPart.getKey(), attachmentPart.getValue());
        }
        return requestEntity;
    }
}

