/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.ContentFetcher;
import org.eclipse.smila.importing.compounds.CompoundExtractor;
import org.eclipse.smila.importing.compounds.CompoundExtractorException;
import org.eclipse.smila.importing.compounds.ExtractorWorkerBase;
import org.eclipse.smila.importing.crawler.file.FileCrawlerService;
import org.eclipse.smila.importing.crawler.file.filter.FilterConfiguration;
import org.eclipse.smila.importing.util.FilePathNormalizer;
import org.eclipse.smila.importing.util.PropertyNameMapper;
import org.eclipse.smila.taskworker.TaskContext;

public class FileExtractorWorker
extends ExtractorWorkerBase {
    public static final String NAME = "fileExtractor";
    private FileCrawlerService _fileCrawler;

    public String getName() {
        return NAME;
    }

    protected Iterator<Record> invokeExtractor(CompoundExtractor extractor, Record compoundRecord, InputStream compoundContent, TaskContext taskContext) throws CompoundExtractorException {
        PropertyNameMapper mapper = PropertyNameMapper.createFrom((TaskContext)taskContext);
        String fileName = compoundRecord.getMetadata().getStringValue((String)mapper.get("filePath").get(0));
        return extractor.extract(compoundContent, fileName, "fileContent");
    }

    protected Record convertRecord(Record compoundRecord, Record extractedRecord, TaskContext taskContext) {
        PropertyNameMapper mapper = PropertyNameMapper.createFrom((TaskContext)taskContext);
        String dataSource = compoundRecord.getSource();
        Record convertedRecord = extractedRecord.getMetadata().containsKey((Object)"isRootCompound") ? compoundRecord : extractedRecord.getFactory().createRecord(String.valueOf(dataSource) + ":" + extractedRecord.getId(), dataSource);
        this.copyAttachment(extractedRecord, convertedRecord, "fileContent");
        this.copySetToStringAttribute(extractedRecord, "compounds", convertedRecord, "filePath", "/");
        this.concatAttributeValues(extractedRecord, "fileName", convertedRecord, "filePath", "/");
        String fileName = FilePathNormalizer.getNormalizedPath((String)convertedRecord.getMetadata().getStringValue("filePath"));
        AnyMap convertedMetadata = convertedRecord.getMetadata();
        convertedMetadata.put("filePath", fileName);
        convertedMetadata.put("fileFolder", FilenameUtils.getPathNoEndSeparator((String)fileName));
        convertedMetadata.put("fileName", FilenameUtils.getName((String)fileName));
        convertedMetadata.put("fileExtension", FilenameUtils.getExtension((String)fileName));
        this.copyAttribute(extractedRecord, "size", convertedRecord, "fileSize");
        this.copyAttribute(compoundRecord, "fileLastModified", convertedRecord, "fileLastModified");
        this.copyAttribute(extractedRecord, "time", convertedRecord, "fileLastModified");
        Date lastModified = convertedMetadata.getDateTimeValue("fileLastModified");
        if (lastModified != null) {
            convertedMetadata.put("_deltaHash", Long.toString(lastModified.getTime()));
        }
        mapper.mapNames(convertedRecord, this._fileCrawler.getFilePropertyNames());
        return convertedRecord;
    }

    protected boolean filterRecord(Record record, TaskContext taskContext) {
        AnyMap filterParams = taskContext.getTaskParameters().getMap("filters");
        PropertyNameMapper mapper = PropertyNameMapper.createFrom((TaskContext)taskContext);
        if (filterParams != null) {
            FilterConfiguration filterConfiguration = new FilterConfiguration(filterParams);
            String mappedFilePathAttributeName = (String)mapper.get("filePath").get(0);
            if (record.getMetadata().containsKey((Object)mappedFilePathAttributeName)) {
                String filePath = record.getMetadata().getStringValue(mappedFilePathAttributeName);
                if (!filterConfiguration.getFilePatternMatcher().matches(FilenameUtils.getName((String)filePath))) {
                    return false;
                }
                if (!filterConfiguration.getFolderPatternMatcher().matches(filePath)) {
                    return false;
                }
            }
            if (mapper.containsMapping("fileSize") && record.getMetadata().containsKey(mapper.get("fileSize").get(0)) && filterConfiguration.getMaxSize() < record.getMetadata().getLongValue((String)mapper.get("fileSize").get(0))) {
                return false;
            }
        }
        return true;
    }

    protected ContentFetcher getContentFetcher() {
        return this._fileCrawler;
    }

    public void setFileCrawlerService(FileCrawlerService fileCrawler) {
        this._fileCrawler = fileCrawler;
    }

    public void unsetFileCrawlerService(FileCrawlerService fileCrawler) {
        if (this._fileCrawler == fileCrawler) {
            this._fileCrawler = null;
        }
    }
}

