/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcRecordWriter;

public class MicroBulkbuilder {
    private static final int MICROBULK_INIT_SIZE = 1000000;
    private final IpcRecordWriter _ipcRecordWriter = new IpcRecordWriter();
    private final Map<String, ByteArrayOutputStream> _microBulks = new ConcurrentHashMap<String, ByteArrayOutputStream>();
    private final Map<String, Integer> _recordCounts = new ConcurrentHashMap<String, Integer>();
    private long _limitOfParallelBulks = -1L;

    public MicroBulkbuilder(long limitOfParallelBulks) {
        this._limitOfParallelBulks = limitOfParallelBulks;
    }

    public void addToMicroBulk(String microBulkId, Record record) throws BulkbuilderException {
        try {
            ByteArrayOutputStream microBulk = this._microBulks.get(microBulkId);
            if (microBulk == null) {
                microBulk = this.initMicroBulk(microBulkId);
            }
            this._ipcRecordWriter.writeBinaryStream(record, (OutputStream)microBulk);
            this.addToRecordCountMap(microBulkId);
        }
        catch (IOException e) {
            throw new BulkbuilderException("Error appending record to micro bulk", e);
        }
    }

    public byte[] finishMicroBulk(String microBulkId) {
        this._recordCounts.remove(microBulkId);
        ByteArrayOutputStream microBulk = this._microBulks.remove(microBulkId);
        if (microBulk == null) {
            return new byte[0];
        }
        return microBulk.toByteArray();
    }

    public Integer getNumberOfRecords(String microBulkId) {
        Integer value = this._recordCounts.get(microBulkId);
        if (value == null) {
            return 0;
        }
        return value;
    }

    private synchronized ByteArrayOutputStream initMicroBulk(String microBulkId) throws BulkbuilderException {
        if (this._limitOfParallelBulks > 0L && (long)this._microBulks.size() >= this._limitOfParallelBulks) {
            throw new BulkbuilderException("No of parallel micro bulks exceeded configured limit " + this._limitOfParallelBulks);
        }
        ByteArrayOutputStream microBulk = new ByteArrayOutputStream(1000000);
        this._microBulks.put(microBulkId, microBulk);
        this._recordCounts.put(microBulkId, 0);
        return microBulk;
    }

    private void addToRecordCountMap(String microBulkId) {
        Integer value = this._recordCounts.get(microBulkId);
        this._recordCounts.put(microBulkId, value + 1);
    }
}

