/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.internal;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import org.eclipse.smila.ontology.config.SesameConfiguration;
import org.eclipse.smila.utils.jaxb.JaxbUtils;
import org.eclipse.smila.utils.xml.SchemaUtils;

public final class SesameConfigurationHandler {
    private SesameConfigurationHandler() {
    }

    public static SesameConfiguration readConfiguration(InputStream configStream) throws JAXBException {
        Unmarshaller parser = SesameConfigurationHandler.createConfigurationUnmarshaller(true);
        return (SesameConfiguration)parser.unmarshal(configStream);
    }

    public static void writeConfiguration(SesameConfiguration configuration, OutputStream configStream) throws JAXBException {
        Marshaller writer = SesameConfigurationHandler.createConfigurationMarshaller(true);
        writer.marshal((Object)configuration, configStream);
    }

    public static Unmarshaller createConfigurationUnmarshaller(boolean validating) throws JAXBException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SesameConfiguration.class.getClassLoader());
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SesameConfiguration.class});
            if (validating) {
                Schema schema = SchemaUtils.loadSchemaRuntimeEx((String)"org.eclipse.smila.ontology", (String)"schemas/sesameConfig.xsd");
                Unmarshaller unmarshaller = JaxbUtils.createValidatingUnmarshaller((JAXBContext)context, (Schema)schema);
                return unmarshaller;
            }
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return unmarshaller;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static Marshaller createConfigurationMarshaller(boolean validating) throws JAXBException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SesameConfiguration.class.getClassLoader());
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SesameConfiguration.class});
            if (validating) {
                Schema schema = SchemaUtils.loadSchemaRuntimeEx((String)"org.eclipse.smila.ontology", (String)"schemas/sesameConfig.xsd");
                Marshaller marshaller = JaxbUtils.createValidatingMarshaller((JAXBContext)context, (Schema)schema);
                return marshaller;
            }
            Marshaller marshaller = context.createMarshaller();
            return marshaller;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

