/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.records;

import java.util.Calendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Value;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class SesameValueHelper {
    public static final SesameValueHelper INSTANCE = new SesameValueHelper();
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    private final Log _log = LogFactory.getLog(this.getClass());

    public Literal createLiteral(RepositoryConnection connection, Value literal, String locale) {
        Literal value;
        switch (literal.getValueType()) {
            case LONG: {
                value = connection.getValueFactory().createLiteral(literal.asLong().longValue());
                break;
            }
            case DOUBLE: {
                value = connection.getValueFactory().createLiteral(literal.asDouble().doubleValue());
                break;
            }
            case BOOLEAN: {
                value = connection.getValueFactory().createLiteral(literal.asBoolean().booleanValue());
                break;
            }
            case DATE: {
                value = this.createDateLiteral(connection, literal);
                break;
            }
            case DATETIME: {
                value = this.createDateTimeLiteral(connection, literal);
                break;
            }
            default: {
                value = locale != null ? connection.getValueFactory().createLiteral(literal.asString(), locale) : connection.getValueFactory().createLiteral(literal.asString());
            }
        }
        return value;
    }

    private Literal createDateLiteral(RepositoryConnection connection, Value literal) {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Calendar cal = Calendar.getInstance();
            cal.setTime(literal.asDate());
            XMLGregorianCalendar time = factory.newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), 0);
            return connection.getValueFactory().createLiteral(time);
        }
        catch (Exception ex) {
            this._log.warn((Object)("cuold not create a time literal from value '" + literal + "', just adding a string literal"), (Throwable)ex);
            return connection.getValueFactory().createLiteral(literal.toString());
        }
    }

    private Literal createDateTimeLiteral(RepositoryConnection connection, Value literal) {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Calendar cal = Calendar.getInstance();
            cal.setTime(literal.asDateTime());
            int zoneOffsetMinutes = cal.get(15) / 60000;
            XMLGregorianCalendar time = factory.newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), zoneOffsetMinutes);
            return connection.getValueFactory().createLiteral(time);
        }
        catch (Exception ex) {
            this._log.warn((Object)("cuold not create a time literal from value '" + literal + "', just adding a string literal"), (Throwable)ex);
            return connection.getValueFactory().createLiteral(literal.toString());
        }
    }

    public URI createUri(RepositoryConnection connection, String uriString) {
        int prefixIndex = uriString.indexOf(58);
        if (prefixIndex >= 0 && prefixIndex < uriString.length() - 1) {
            String prefix = uriString.substring(0, prefixIndex);
            try {
                String fullNamespace = connection.getNamespace(prefix);
                if (fullNamespace != null) {
                    String localName = uriString.substring(prefixIndex + 1);
                    return connection.getValueFactory().createURI(fullNamespace, localName);
                }
            }
            catch (RepositoryException repositoryException) {
            }
        }
        return connection.getValueFactory().createURI(uriString);
    }
}

