/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.compounds.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.common.mimetype.MimeTypeIdentifier;
import org.eclipse.smila.common.mimetype.MimeTypeParseException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.importing.compounds.CompoundExtractor;
import org.eclipse.smila.importing.compounds.CompoundExtractorException;
import org.eclipse.smila.utils.config.ConfigUtils;

public class SimpleCompoundExtractorService
implements CompoundExtractor {
    protected static final String APPLICATION_ZIP = "application/zip";
    protected static final Collection<String> SUPPORTED_MIME_TYPES = Arrays.asList("application/zip", "application/x-gunzip", "application/x-gzip");
    private static final String OCTET_STREAM = "application/octet-stream";
    private static final String KEY_TMP_FILE_NAME = "tmpFileName";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String BUNDLE_ID = "org.eclipse.smila.importing.compounds.simple";
    protected MimeTypeIdentifier _mimeTypeIdentifier;
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected Charset _charset = DEFAULT_CHARSET;
    private File _rootTmpDir;

    protected void activate() {
        String rootTmpDirName;
        Properties props;
        try {
            props = ConfigUtils.getConfigProperties((String)BUNDLE_ID, (String)"extractor.properties");
        }
        catch (Exception exception) {
            this._log.info((Object)"No configuration org.eclipse.smila.importing.compounds.simple/ found, using default settings.");
            props = new Properties();
        }
        if (props.containsKey("zip.encoding")) {
            this._charset = Charset.forName(props.getProperty("zip.encoding"));
        }
        this._rootTmpDir = (rootTmpDirName = props.getProperty("tmp.dir", null)) != null ? new File(rootTmpDirName) : new File(FileUtils.getTempDirectoryPath(), BUNDLE_ID);
        try {
            FileUtils.deleteDirectory((File)this._rootTmpDir);
        }
        catch (IOException iOException) {
            this._log.warn((Object)"Could not delete old temporary files from previous invocation");
        }
    }

    protected void deactivate() {
        if (this._rootTmpDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)this._rootTmpDir);
            }
            catch (IOException e) {
                this._log.warn((Object)"Could not clean up temp extraction directory.", (Throwable)e);
            }
        }
    }

    public boolean canExtract(File file) {
        if (file == null) {
            return false;
        }
        return this.canExtract(file.getName());
    }

    public boolean canExtract(URL url, String mimeType) {
        if (url == null) {
            return false;
        }
        return this.canExtract(url.getFile(), mimeType);
    }

    public boolean canExtract(String fileName, String mimeType) {
        if (fileName == null) {
            return false;
        }
        return this.canHandleMimeType(this.getMimeType(fileName, mimeType));
    }

    public Iterator<Record> extract(InputStream compoundInputStream, String fileName, String contentAttachmentName) throws CompoundExtractorException {
        return this.extract(compoundInputStream, fileName, null, contentAttachmentName);
    }

    public Iterator<Record> extract(InputStream compoundInputStream, String fileName, String mimeType, final String contentAttachmentName) throws CompoundExtractorException {
        String extractedMimeType = this.getMimeType(fileName, mimeType);
        if (!this.canHandleMimeType(extractedMimeType)) {
            return new ArrayList().iterator();
        }
        final File tmpDir = new File(this._rootTmpDir, UUID.randomUUID().toString());
        Collection<Record> records = this.extractCompressedStream(compoundInputStream, fileName, extractedMimeType, tmpDir, new ArrayList<String>(), null);
        final Iterator<Record> recordIterator = records.iterator();
        return new Iterator<Record>(){

            @Override
            public boolean hasNext() {
                return recordIterator.hasNext();
            }

            @Override
            public Record next() {
                Record record = (Record)recordIterator.next();
                if (record != null && record.getMetadata().containsKey((Object)SimpleCompoundExtractorService.KEY_TMP_FILE_NAME)) {
                    File file = new File(record.getMetadata().getStringValue(SimpleCompoundExtractorService.KEY_TMP_FILE_NAME));
                    try {
                        record.setAttachment(contentAttachmentName, FileUtils.readFileToByteArray((File)file));
                    }
                    catch (IOException e) {
                        SimpleCompoundExtractorService.this._log.warn((Object)("Cannot access temporary extracted file '" + file.getAbsolutePath() + "'."), (Throwable)e);
                    }
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                }
                if (!this.hasNext()) {
                    try {
                        FileUtils.deleteDirectory((File)tmpDir);
                    }
                    catch (IOException iOException) {
                        SimpleCompoundExtractorService.this._log.warn((Object)("Could not remove temporary directory '" + tmpDir.getAbsolutePath() + "'."));
                    }
                }
                return record;
            }

            @Override
            public void remove() {
                recordIterator.remove();
            }

            protected void finalize() {
                try {
                    if (recordIterator.hasNext()) {
                        FileUtils.deleteDirectory((File)tmpDir);
                    }
                }
                catch (IOException iOException) {
                    SimpleCompoundExtractorService.this._log.warn((Object)("Could not remove temporary directory '" + tmpDir.getAbsolutePath() + "'."));
                }
                try {
                    super.finalize();
                }
                catch (Throwable t) {
                    SimpleCompoundExtractorService.this._log.warn((Object)"Error while cleaning up iterator. ", t);
                }
            }
        };
    }

    public void setMimeTypeIdentifier(MimeTypeIdentifier mimeTypeIdentifier) {
        this._mimeTypeIdentifier = mimeTypeIdentifier;
    }

    public void unsetMimeTypeIdentifier(MimeTypeIdentifier mimeTypeIdentifier) {
        if (this._mimeTypeIdentifier == mimeTypeIdentifier) {
            this._mimeTypeIdentifier = null;
        }
    }

    private String getMimeType(String fileName, String mimeType) {
        if (mimeType == null || mimeType.isEmpty() || mimeType.toLowerCase(Locale.ENGLISH).contains(OCTET_STREAM)) {
            return this.getMimeType(fileName);
        }
        return mimeType;
    }

    private String getMimeType(String fileName) {
        int indexOfLastPeriod = fileName.lastIndexOf(46);
        if (indexOfLastPeriod >= 0 && fileName.length() > indexOfLastPeriod) {
            try {
                return this._mimeTypeIdentifier.identify(fileName.substring(indexOfLastPeriod + 1));
            }
            catch (MimeTypeParseException e) {
                this._log.warn((Object)("Cannot detect mime type for '" + fileName + "'."), (Throwable)e);
            }
        }
        return null;
    }

    private boolean canExtract(String fileName) {
        return this.canHandleMimeType(this.getMimeType(fileName));
    }

    private boolean canHandleMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return SUPPORTED_MIME_TYPES.contains(mimeType.toLowerCase(Locale.ENGLISH));
    }

    private Collection<Record> extractCompressedStream(InputStream compoundInputStream, String fileName, String extractedMimeType, File tmpDir, List<String> compoundNames, Record record) throws CompoundExtractorException {
        ArrayList<Record> records = new ArrayList<Record>();
        ArrayList<String> newCompoundNames = new ArrayList<String>(compoundNames);
        if (newCompoundNames.isEmpty()) {
            newCompoundNames.add(fileName);
        }
        if (record == null) {
            Record newRecord = DataFactory.DEFAULT.createRecord(fileName);
            newRecord.getMetadata().put("isCompound", Boolean.valueOf(true));
            newRecord.getMetadata().put("fileName", fileName);
            newRecord.getMetadata().put("isRootCompound", Boolean.valueOf(true));
            records.add(newRecord);
        } else {
            records.add(record);
        }
        if (extractedMimeType.equalsIgnoreCase(APPLICATION_ZIP)) {
            records.addAll(this.extractZipContent(compoundInputStream, fileName, tmpDir, newCompoundNames));
        } else {
            records.addAll(this.extractGzipContent(compoundInputStream, fileName, tmpDir, newCompoundNames, record));
        }
        return records;
    }

    private Collection<Record> extractGzipContent(InputStream compoundInputStream, String fileName, File tmpDir, List<String> compoundNames, Record compoundRecord) throws CompoundExtractorException {
        ArrayList<Record> records = new ArrayList<Record>();
        try {
            File tmp = new File(fileName);
            String tmpName = tmp.getName();
            String gunzippedFileName = tmpName.substring(0, tmpName.lastIndexOf(46));
            File destFile = this.gunzip(compoundInputStream, gunzippedFileName, tmpDir);
            StringBuilder id = new StringBuilder();
            for (String compoundName : compoundNames) {
                id.append(compoundName).append('/');
            }
            id.append(gunzippedFileName);
            Record record = DataFactory.DEFAULT.createRecord(id.toString());
            record.getMetadata().put("fileName", gunzippedFileName);
            record.getMetadata().put("size", (Number)destFile.length());
            if (compoundRecord != null && compoundRecord.getMetadata().containsKey((Object)"time")) {
                record.getMetadata().put("time", (Any)compoundRecord.getMetadata().get((Object)"time"));
            }
            if (!compoundNames.isEmpty()) {
                record.getMetadata().put("compounds", AnyUtil.objectToAny(compoundNames));
            }
            this.checkAndHandleCompoundFile(gunzippedFileName, tmpDir, compoundNames, records, destFile, record);
        }
        catch (IOException e) {
            this._log.warn((Object)("Cannot access zipped stream for '" + fileName + "'."), (Throwable)e);
        }
        return records;
    }

    private void checkAndHandleCompoundFile(String fileName, File tmpDir, List<String> compoundNames, Collection<Record> records, File destFile, Record record) throws CompoundExtractorException, IOException {
        if (this.canExtract(destFile)) {
            String mimeType = this.getMimeType(destFile.getName());
            record.getMetadata().put("isCompound", Boolean.valueOf(true));
            FileInputStream compressedFileStream = new FileInputStream(destFile);
            try {
                ArrayList<String> newCompoundNames = new ArrayList<String>(compoundNames);
                newCompoundNames.add(fileName);
                records.addAll(this.extractCompressedStream(compressedFileStream, destFile.getName(), mimeType, new File(tmpDir, UUID.randomUUID().toString()), newCompoundNames, record));
            }
            finally {
                IOUtils.closeQuietly((InputStream)compressedFileStream);
            }
            if (!destFile.delete()) {
                destFile.deleteOnExit();
            }
        } else {
            record.getMetadata().put(KEY_TMP_FILE_NAME, destFile.getCanonicalPath());
            records.add(record);
        }
    }

    private Collection<Record> extractZipContent(InputStream compoundInputStream, String fileName, File tmpDir, List<String> compoundNames) throws CompoundExtractorException {
        ArrayList<Record> records = new ArrayList<Record>();
        ZipInputStream zin = new ZipInputStream(compoundInputStream, this._charset);
        try {
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String entryName = entry.getName();
                    StringBuilder id = new StringBuilder();
                    for (String compoundName : compoundNames) {
                        id.append(compoundName).append('/');
                    }
                    id.append(entryName);
                    Record record = DataFactory.DEFAULT.createRecord(id.toString());
                    record.getMetadata().put("fileName", entry.getName());
                    record.getMetadata().put("size", (Number)entry.getSize());
                    if (entry.getComment() != null) {
                        record.getMetadata().put("comment", entry.getComment());
                    }
                    record.getMetadata().put("compressedSize", (Number)entry.getCompressedSize());
                    if (entry.getTime() != -1L) {
                        record.getMetadata().put("time", (Any)DataFactory.DEFAULT.createDateTimeValue(new Date(entry.getTime())));
                    }
                    if (!compoundNames.isEmpty()) {
                        record.getMetadata().put("compounds", AnyUtil.objectToAny(compoundNames));
                    }
                    try {
                        File destFile = new File(tmpDir, entry.getName());
                        if (!destFile.getParentFile().exists()) {
                            destFile.getParentFile().mkdirs();
                        }
                        destFile.createNewFile();
                        FileOutputStream fos = new FileOutputStream(destFile);
                        try {
                            IOUtils.copy((InputStream)zin, (OutputStream)fos);
                        }
                        finally {
                            IOUtils.closeQuietly((OutputStream)fos);
                        }
                        zin.closeEntry();
                        this.checkAndHandleCompoundFile(entryName, tmpDir, compoundNames, records, destFile, record);
                    }
                    catch (IOException e) {
                        this._log.warn((Object)("Some error occurred while trying to access zip entry for zip file '" + fileName + "'."), (Throwable)e);
                    }
                }
                entry = zin.getNextEntry();
            }
        }
        catch (IOException e) {
            this._log.warn((Object)("Cannot access zipped stream for '" + fileName + "'."), (Throwable)e);
        }
        return records;
    }

    /*
     * Loose catch block
     */
    private File gunzip(InputStream compoundInputStream, String gunzippedFileName, File tmpDir) throws CompoundExtractorException, IOException {
        GZIPInputStream zin = null;
        zin = new GZIPInputStream(compoundInputStream);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        File destFile = File.createTempFile("tmp", gunzippedFileName, tmpDir);
        destFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(destFile);
        IOUtils.copy((InputStream)zin, (OutputStream)fos);
        File file = destFile;
        IOUtils.closeQuietly((OutputStream)fos);
        IOUtils.closeQuietly((InputStream)zin);
        return file;
        {
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((OutputStream)fos);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(zin);
                    throw throwable2;
                }
            }
        }
    }
}

