/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.solr.util.SolrProperties;

public class SolrHelper {
    private static final String SOLR_INSTANCE_DIR = "conf";
    private static final String SOLR_DATA_DIR = "data";
    private static final String SOLR_XML = "solr.xml";
    private static final String SOLR_CONFIG = "solrconfig.xml";
    private static final String SOLR_SCHEMA = "schema.xml";
    private final Log _log = LogFactory.getLog(SolrHelper.class);
    private final SolrProperties _properties;

    public SolrHelper(SolrProperties properties) throws IOException {
        this._properties = properties;
        this.initializeWorkspace();
    }

    public void copyCoreConfig(String srcName, String targetName) throws IOException {
        File srcDir = this.getFile(this._properties.getWorkspaceFolder().getPath(), srcName, SOLR_INSTANCE_DIR);
        if (!srcDir.isDirectory()) {
            srcDir = this.getFile(this._properties.getConfigurationFolder().getPath(), srcName, SOLR_INSTANCE_DIR);
        }
        if (!srcDir.isDirectory()) {
            throw new FileNotFoundException("source core (folder) doesnt exist: " + srcDir.getAbsolutePath());
        }
        File destDir = this.getFile(this._properties.getWorkspaceFolder().getPath(), targetName, SOLR_INSTANCE_DIR);
        if (destDir.isDirectory()) {
            throw new IllegalArgumentException("A core directory with the specified name already exists in workspace: " + destDir);
        }
        FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)FileFilterUtils.makeSVNAware(null));
    }

    private File getFile(String ... pathParts) throws IOException {
        String path = StringUtils.join((Object[])pathParts, (char)File.separatorChar);
        return new File(path);
    }

    public File getCoreRootDir(String core) throws IOException {
        return new File(this.getSolrHome(), core);
    }

    public File getCoreDataDir(String core) throws IOException {
        return new File(this.getCoreRootDir(core), SOLR_DATA_DIR);
    }

    public File getCoreInstanceDir(String core) throws IOException {
        return new File(this.getCoreRootDir(core), SOLR_INSTANCE_DIR);
    }

    public File getSolrConfigByCore(String core) throws IOException {
        return new File(this.getCoreInstanceDir(core), SOLR_CONFIG);
    }

    public File getSolrSchemaByCore(String core) throws IOException {
        return new File(this.getCoreInstanceDir(core), SOLR_SCHEMA);
    }

    public File getSolrHome() throws IOException {
        return this._properties.getWorkspaceFolder();
    }

    public File getSolrXML() throws IOException {
        return new File(this.getSolrHome(), SOLR_XML);
    }

    public String getDataDirPath(String coreName) {
        return String.valueOf(coreName) + File.separator + SOLR_DATA_DIR;
    }

    private void initializeWorkspace() throws IOException {
        File[] folders;
        String[] solrWorkspaceContent = this._properties.getWorkspaceFolder().list();
        if (solrWorkspaceContent != null && solrWorkspaceContent.length > 0) {
            return;
        }
        File configurationFolder = this._properties.getConfigurationFolder();
        File srcFile = new File(configurationFolder, SOLR_XML);
        if (!srcFile.exists()) {
            throw new FileNotFoundException("need for initialization missing file: " + srcFile.getAbsolutePath());
        }
        File destFile = this.getSolrXML();
        FileUtils.copyFile((File)srcFile, (File)destFile);
        File[] fileArray = folders = configurationFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File potentialCoreDir = fileArray[n2];
            try {
                File file = new File(potentialCoreDir, SOLR_INSTANCE_DIR);
                File destDir = this.getCoreRootDir(potentialCoreDir.getName());
                if (file.isDirectory()) {
                    FileUtils.copyDirectory((File)potentialCoreDir, (File)destDir, (FileFilter)FileFilterUtils.makeSVNAware(null));
                }
            }
            catch (Exception exception) {
                this._log.warn((Object)("failure on copying core config: " + potentialCoreDir));
            }
            ++n2;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Solr workspace initialized successfully in solr.home directory: " + this.getSolrHome()));
        }
    }
}

