/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class Axis2WSDLLocator
implements WSDLLocator {
    private static final Log LOG = LogFactory.getLog(Axis2WSDLLocator.class);
    private URI _baseUri;
    private String _latest;

    public Axis2WSDLLocator(URI uRI) throws URISyntaxException {
        this._baseUri = uRI;
    }

    public InputSource getBaseInputSource() {
        try {
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(this.openResource(this._baseUri));
            inputSource.setSystemId(this._baseUri.toString());
            return inputSource;
        }
        catch (IOException iOException) {
            LOG.error((Object)("Unable to create InputSource for " + this._baseUri), (Throwable)iOException);
            return null;
        }
    }

    public InputSource getImportInputSource(String string, String string2) {
        URI uRI;
        try {
            uRI = string == null ? this._baseUri.resolve(string2) : new URI(string).resolve(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.error((Object)("URI syntax error: parent=" + string + " error=" + uRISyntaxException));
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get import:  import=" + string2 + " parent=" + string));
        }
        InputSource inputSource = new InputSource();
        try {
            inputSource.setByteStream(this.openResource(uRI));
        }
        catch (Exception exception) {
            LOG.error((Object)("Unable to open import resource: " + uRI), (Throwable)exception);
            return null;
        }
        inputSource.setSystemId(uRI.toString());
        this._latest = uRI.toString();
        return inputSource;
    }

    public String getBaseURI() {
        return this._baseUri.toString();
    }

    public String getLatestImportURI() {
        return this._latest;
    }

    public void close() {
    }

    public InputStream openResource(URI uRI) throws IOException {
        if (uRI.isAbsolute() && uRI.getScheme().equals("file")) {
            try {
                return uRI.toURL().openStream();
            }
            catch (Exception exception) {
                LOG.error((Object)("openResource: unable to open file URL " + uRI + "; " + exception.toString()));
                return null;
            }
        }
        URI uRI2 = this._baseUri.relativize(uRI);
        if (uRI2.isAbsolute() && !uRI2.getScheme().equals("urn")) {
            LOG.error((Object)("openResource: invalid scheme (should be urn:)  " + uRI));
            return null;
        }
        File file = new File(this._baseUri.getPath(), uRI2.getPath());
        if (!file.exists()) {
            LOG.error((Object)("openResource: file not found " + file));
            return null;
        }
        return new FileInputStream(file);
    }
}

