/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.zookeeper.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.smila.clusterconfig.ClusterConfigException;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.eclipse.smila.zookeeper.ZooKeeperService;
import org.eclipse.smila.zookeeper.internal.ZooKeeperGC;
import org.eclipse.smila.zookeeper.internal.ZooKeeperServerRunner;
import org.osgi.service.component.ComponentContext;

public class ZooKeeperServiceImpl
implements ZooKeeperService,
Watcher {
    private static final String CONFIG_FILENAME = "zoo.cfg";
    private static final int WAIT_FOR_RECONNECTION_TIMEOUT = 60;
    private static final long MINUTES_TO_MILLISECONDS = 60000L;
    private static final String MYID_FILE_NAME = "myid";
    private static final String ENV_DATADIR = "SMILA_ZK_DATADIR";
    private static final String PROP_DATADIR = "dataDir";
    private static final String PROP_DATALOGDIR = "dataLogDir";
    private static final String PROPERTY_ZK_SERVER_PORT = "zk.serverPort";
    private static final String PROPERTY_ZK_ELECTION_PORT = "zk.electionPort";
    private static final String PROP_SNAPSHOTSTOKEEP = "zk.snapshotsToKeep";
    private static final int DEFAULT_ZK_SERVER_PORT = 2888;
    private static final int DEFAULT_ZK_ELECTION_PORT = 3888;
    private static final int DEFAULT_SNAPSHOTSTOKEEP = 5;
    private static final int MINIMUM_SNAPSHOTSTOKEEP = 3;
    private static final String ARG_RESUME_JOBS = "-resumeJobs";
    private static final String ARG_DISCARD_JOBS = "-discardJobs";
    private ArrayList<String> _clusterNodeAddresses;
    private final Log _log = LogFactory.getLog(this.getClass());
    private QuorumPeerConfig _quorumPeerConfig;
    private Thread _serverRunnerThread;
    private ZooKeeperServerRunner _serverRunner;
    private ClusterConfigService _clusterService;
    private EnvironmentInfo _environmentInfo;
    private long _maxFailedNodes = -1L;
    private ZooKeeperGC _gc;
    private Thread _gcThread;
    private ZooKeeper _zkClient;
    private Watcher.Event.KeeperState _zkClientState;
    private final Lock _zkEventLock = new ReentrantLock(true);
    private final Condition _zkEventLockCondition = this._zkEventLock.newCondition();
    private final Collection<Watcher> _watchers = new CopyOnWriteArraySet<Watcher>();

    @Override
    public ZooKeeper getClient() throws IOException, ClusterConfigException {
        if (this._zkClient == null) {
            int timeout = this._quorumPeerConfig.getMaxSessionTimeout();
            this.createClient(timeout, this);
        }
        return this._zkClient;
    }

    private void createClient(int sessionTimeout, Watcher watcher) throws IOException, ClusterConfigException {
        this._zkEventLock.lock();
        try {
            if (this._zkClient == null) {
                StringBuffer connectionString = new StringBuffer();
                if (this._clusterNodeAddresses != null && this._clusterNodeAddresses.size() > 0) {
                    for (String node : this._clusterNodeAddresses) {
                        if (connectionString.length() > 0) {
                            connectionString.append(",");
                        }
                        connectionString.append(String.valueOf(node) + ":" + this._quorumPeerConfig.getClientPortAddress().getPort());
                    }
                } else {
                    connectionString.append("127.0.0.1:" + this._quorumPeerConfig.getClientPortAddress().getPort());
                }
                this._log.debug((Object)("Connecting to Zookeper with connectionString " + connectionString + ", timeout is " + sessionTimeout + " ms, Watcher is instance of " + watcher.getClass()));
                this._zkClient = new ZooKeeper(connectionString.toString(), sessionTimeout, watcher);
                this._log.info((Object)("Created new Zookeeper client: " + this._zkClient));
            }
        }
        finally {
            this._zkEventLock.unlock();
        }
    }

    @Override
    public void closeClient() {
        if (this._zkClient != null) {
            this._zkEventLock.lock();
            try {
                try {
                    if (this._zkClient != null) {
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)"closeClient(): closing client.");
                        }
                        this._zkClient.close();
                    }
                }
                catch (Exception ex) {
                    this._log.warn((Object)"Error while closing zookeeper client", (Throwable)ex);
                    this._zkClient = null;
                    this._zkEventLock.unlock();
                }
            }
            finally {
                this._zkClient = null;
                this._zkEventLock.unlock();
            }
        }
    }

    @Override
    public long getFailSafetyLevel() {
        if (this._maxFailedNodes < 0L) {
            this._maxFailedNodes = this.isClusterStart() ? this._clusterService.getFailSafetyLevel() : 0L;
        }
        return this._maxFailedNodes;
    }

    protected void activate(ComponentContext context) {
        InputStream propStream = ConfigUtils.getConfigStream((String)"org.eclipse.smila.zookeeper", (String)CONFIG_FILENAME);
        try {
            try {
                Properties props = new Properties();
                props.load(propStream);
                String dataDir = this.prepareDataDir(props);
                String dataLogDir = this.prepareDataLogDir(props);
                this.createMyIdFile(props);
                this.addQuorumPeersToConfig(props);
                this._quorumPeerConfig = new QuorumPeerConfig();
                this._quorumPeerConfig.parseProperties(props);
                this._serverRunner = new ZooKeeperServerRunner(this._quorumPeerConfig, this.isClusterStart(), this.getMyId());
                this._serverRunnerThread = new Thread((Runnable)this._serverRunner, "ZooKeeperServerRunner");
                this._serverRunnerThread.start();
                long gcInterval = this.getGCInterval();
                if (gcInterval > 0L) {
                    int snapshotsToKeep = this.getSnapshotsToKeep(props);
                    long gcIntervalInMillis = gcInterval * 60000L;
                    this._gc = new ZooKeeperGC(gcIntervalInMillis, dataDir, dataLogDir, snapshotsToKeep);
                    this._gcThread = new Thread((Runnable)this._gc, "ZooKeeperService:ZooKeeperGC");
                    this._gcThread.start();
                    this._log.info((Object)("GC started with interval " + gcInterval + " minutes and " + snapshotsToKeep + " files to keep."));
                } else {
                    this._log.info((Object)"GC is disabled!");
                }
            }
            catch (Throwable ex) {
                this._log.error((Object)"Error while activating org.eclipse.smila.zookeeper", ex);
                throw new RuntimeException("Error while activating org.eclipse.smila.zookeeper", ex);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)propStream);
        }
    }

    protected void deactivate(ComponentContext context) {
        this._maxFailedNodes = -1L;
        if (this._gc != null) {
            this._gc.stop();
        }
        if (this._gcThread != null) {
            try {
                this._gcThread.join();
            }
            catch (InterruptedException e) {
                this._log.error((Object)"Interrupted while waiting for GC shutdown", (Throwable)e);
            }
        }
        this._gc = null;
        this._gcThread = null;
        if (this._serverRunnerThread != null && this._serverRunnerThread.isAlive()) {
            this._serverRunner.shutdown();
            try {
                this._serverRunnerThread.join();
            }
            catch (InterruptedException e) {
                this._log.warn((Object)"Interrupted while waiting for server to shutdown", (Throwable)e);
            }
        }
        this.closeClient();
    }

    private String prepareDataDir(Properties props) {
        String dataDir = props.getProperty(PROP_DATADIR);
        if (dataDir == null) {
            dataDir = System.getenv(ENV_DATADIR);
        }
        boolean dataDirOk = false;
        if (dataDir != null) {
            try {
                this.ensureDirectory(new File(dataDir));
                dataDirOk = true;
            }
            catch (IOException ex) {
                this._log.error((Object)("Could not create clean data directory " + dataDir + ", trying directory in workspace."), (Throwable)ex);
            }
        }
        if (!dataDirOk) {
            File workingDir = null;
            try {
                workingDir = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.zookeeper");
                this.ensureDirectory(workingDir);
            }
            catch (IOException ex) {
                this._log.error((Object)"Could not create clean data directory in workspace for org.eclipse.smila.zookeeper, creating temp directory. Please check workspace directory.", (Throwable)ex);
                try {
                    workingDir = File.createTempFile("org.eclipse.smila.zookeeper-", "");
                    this.ensureDirectory(workingDir);
                }
                catch (IOException ex2) {
                    this._log.error((Object)"Error creating clean fallback working directory, strange behaviour may occur. Good luck.", (Throwable)ex2);
                }
            }
            dataDir = workingDir.getAbsolutePath();
        }
        props.setProperty(PROP_DATADIR, dataDir);
        this._log.info((Object)("ZooKeeper snapshot data directory is " + dataDir));
        return dataDir;
    }

    private String prepareDataLogDir(Properties props) {
        String dataDir = props.getProperty(PROP_DATADIR);
        String dataLogDir = props.getProperty(PROP_DATALOGDIR);
        boolean dataLogDirOk = false;
        if (dataLogDir != null) {
            try {
                this.ensureDirectory(new File(dataLogDir));
                dataLogDirOk = true;
            }
            catch (IOException ex) {
                this._log.error((Object)("Could not create clean transaction log directory " + dataDir + ", using data directory for transaction logs, too."), (Throwable)ex);
            }
        }
        if (!dataLogDirOk) {
            dataLogDir = dataDir;
            props.put(PROP_DATALOGDIR, dataLogDir);
        }
        this._log.info((Object)("ZooKeeper transaction log directory is " + dataLogDir));
        return dataLogDir;
    }

    private int getSnapshotsToKeep(Properties props) {
        int snapshotsToKeep = this.getIntProperty(props, PROP_SNAPSHOTSTOKEEP, 5);
        if (snapshotsToKeep < 3) {
            this._log.info((Object)"The value of property zk.snapshotsToKeep must not be less than 3, correcting.");
            snapshotsToKeep = 3;
        }
        return snapshotsToKeep;
    }

    private int getIntProperty(Properties props, String name, int defaultValue) {
        String propValue = props.getProperty(name);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue.trim());
            }
            catch (NumberFormatException ex) {
                this._log.warn((Object)("Invalid value " + propValue + " for property " + name + ", using default value " + defaultValue + " instead."), (Throwable)ex);
            }
        }
        return defaultValue;
    }

    private void ensureDirectory(File location) throws IOException {
        boolean doCleanup = this.doCleanup();
        if (location.exists()) {
            if (doCleanup) {
                if (location.isDirectory()) {
                    FileUtils.deleteDirectory((File)location);
                } else if (!location.delete()) {
                    throw new IOException("Could not delete " + location);
                }
                if (!location.mkdir()) {
                    throw new IOException("Could not create new directory at " + location);
                }
            }
        } else if (!location.mkdir()) {
            throw new IOException("Could not create new directory at " + location);
        }
    }

    private void createMyIdFile(Properties props) throws IOException, ClusterConfigException {
        String dataDir = props.getProperty(PROP_DATADIR);
        File dataDirFile = new File(dataDir, MYID_FILE_NAME);
        long myid = this.getMyId();
        try (BufferedWriter myidOut = null;){
            FileWriter myidWriter = new FileWriter(dataDirFile);
            myidOut = new BufferedWriter(myidWriter);
            myidOut.write(String.valueOf(myid));
            myidOut.flush();
        }
    }

    private void addQuorumPeersToConfig(Properties props) throws ClusterConfigException {
        long nodeNo = 0L;
        if (this.isClusterStart()) {
            long maxFailedNodes = this.getFailSafetyLevel();
            if (ZooKeeperServiceImpl.isObserverNode(this.getMyId(), maxFailedNodes)) {
                props.put("peerType", "observer");
            }
            int serverPort = this.getIntProperty(props, PROPERTY_ZK_SERVER_PORT, 2888);
            int electionPort = this.getIntProperty(props, PROPERTY_ZK_ELECTION_PORT, 3888);
            this.findIPAddressesOfClusterNodes(serverPort);
            for (String node : this._clusterService.getClusterNodes()) {
                String key = "server." + ++nodeNo;
                StringBuffer value = new StringBuffer(String.valueOf(node) + ":" + serverPort + ":" + electionPort);
                if (ZooKeeperServiceImpl.isObserverNode(nodeNo, maxFailedNodes)) {
                    value.append(":observer");
                }
                props.put(key, value.toString());
            }
        }
    }

    private static boolean isObserverNode(long nodeNo, long maxFailedNodes) {
        return nodeNo > 0L && maxFailedNodes > 0L && nodeNo > maxFailedNodes * 2L + 1L;
    }

    private long getMyId() throws ClusterConfigException {
        long nodeNo = 0L;
        if (this._clusterService.isConfigured()) {
            String myHost = this._clusterService.getLocalHost();
            for (String node : this._clusterService.getClusterNodes()) {
                ++nodeNo;
                if (!node.equals(myHost)) continue;
                return nodeNo;
            }
            throw new ClusterConfigException("Could not find local host " + myHost + " in cluster nodes: " + this._clusterService.getClusterNodes());
        }
        return nodeNo;
    }

    private boolean isClusterStart() {
        try {
            return this._clusterService.isConfigured() && this._clusterService.getClusterNodes().size() > 1;
        }
        catch (ClusterConfigException e) {
            this._log.warn((Object)"Error reading cluster config", (Throwable)e);
            return false;
        }
    }

    private long getGCInterval() throws ClusterConfigException {
        long gcInterval = this._clusterService.getZkGcInterval();
        return gcInterval;
    }

    public void setClusterConfigService(ClusterConfigService clusterConfigService) {
        this._clusterService = clusterConfigService;
    }

    public void unsetClusterConfigService(ClusterConfigService clusterConfigService) {
        if (this._clusterService == clusterConfigService) {
            this._clusterService = null;
        }
    }

    public void setEnvironmentInfo(EnvironmentInfo environmentInfo) {
        this._environmentInfo = environmentInfo;
    }

    public void unsetEnvironmentInfo(EnvironmentInfo environmentInfo) {
        if (this._environmentInfo == environmentInfo) {
            this._environmentInfo = null;
        }
    }

    private void findIPAddressesOfClusterNodes(int port) {
        this._clusterNodeAddresses = new ArrayList();
        try {
            if (this._clusterService.isConfigured()) {
                List nodes = this._clusterService.getClusterNodes();
                for (String host : nodes) {
                    InetSocketAddress address = new InetSocketAddress(host, port);
                    if (!address.isUnresolved()) {
                        this._clusterNodeAddresses.add(address.getAddress().getHostAddress());
                        continue;
                    }
                    this._log.warn((Object)("Getting IP sddress of host " + host + " failed. Host name will be used."));
                    this._clusterNodeAddresses.add(host);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Getting ip addresses of cluster nodes failed", ex);
        }
    }

    @Override
    public void waitForClientConnected() {
        this._zkEventLock.lock();
        try {
            try {
                boolean stillWaiting = true;
                boolean triedClientRecreation = false;
                while (this._zkClientState != Watcher.Event.KeeperState.SyncConnected) {
                    if (stillWaiting) {
                        stillWaiting = this._zkEventLockCondition.await(60L, TimeUnit.SECONDS);
                        continue;
                    }
                    if (triedClientRecreation) {
                        throw new RuntimeException("Waited 60 seconds after Zookeeper client recreation");
                    }
                    try {
                        this._log.warn((Object)"Waited 60 seconds for Zookeeper client reconnection, will try recreation");
                        this.recreateZkClient();
                        triedClientRecreation = true;
                        stillWaiting = true;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while recreating zookeeper client", e);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this._zkEventLock.unlock();
        }
    }

    public void process(WatchedEvent event) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("process watched event: " + event.getState()));
        }
        try {
            try {
                this._zkEventLock.lock();
                if (event.getPath() == null) {
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("Zookeeper client state changed from '" + this._zkClientState + "' to '" + event.getState() + "'"));
                    }
                    this._zkClientState = event.getState();
                    if (event.getState() == Watcher.Event.KeeperState.Expired) {
                        this._log.warn((Object)"got zookeeper session expired event - recreating zookeeper client");
                        this.recreateZkClient();
                    }
                    this._zkEventLockCondition.signalAll();
                } else {
                    for (Watcher watcher : this._watchers) {
                        try {
                            watcher.process(event);
                        }
                        catch (Throwable t) {
                            this._log.error((Object)"Watcher failed. ", t);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error while processing zookeeper watched event: " + event, e);
            }
        }
        finally {
            this._zkEventLock.unlock();
        }
    }

    @Override
    public void registerWatcher(Watcher watcher) {
        this._watchers.add(watcher);
    }

    @Override
    public void unregisterWatcher(Watcher watcher) {
        this._watchers.remove(watcher);
    }

    private void recreateZkClient() throws IOException, ClusterConfigException {
        this._log.info((Object)"recreating zookeeper client");
        this._zkEventLock.lock();
        try {
            this.closeClient();
            this.getClient();
        }
        finally {
            this._zkEventLock.unlock();
        }
    }

    @Override
    public AnyMap getServerState() {
        AnyMap zkState = DataFactory.DEFAULT.createAnyMap();
        AnyMap localState = DataFactory.DEFAULT.createAnyMap();
        String myState = this._serverRunner.getServerState();
        localState.put(this._clusterService.getLocalHost(), myState);
        localState.put("operational", Boolean.valueOf(this.isOperational()));
        localState.put("clean up data on start", Boolean.valueOf(this.doCleanup()));
        localState.putAll((Map)this._serverRunner.getServerStatistics());
        zkState.put("local server", (Any)localState);
        if (this._clusterService.isConfigured()) {
            try {
                AnyMap clusterState = DataFactory.DEFAULT.createAnyMap();
                List nodes = this._clusterService.getClusterNodes();
                if (nodes.size() > 1) {
                    long maxFailNodes = this._clusterService.getFailSafetyLevel();
                    String leaderConn = this._serverRunner.getRemoteLeaderConnection();
                    long noOfFollowers = maxFailNodes * 2L + 1L;
                    int i = 0;
                    while (i < nodes.size()) {
                        String node = (String)nodes.get(i);
                        if ((long)i < noOfFollowers) {
                            if (leaderConn != null && leaderConn.contains(String.valueOf(node) + "/")) {
                                clusterState.put(node, "Leader");
                            } else if (node.equals(this._clusterService.getLocalHost()) && "leading".equals(myState)) {
                                clusterState.put(node, "Leader");
                            } else {
                                clusterState.put(node, "Follower");
                            }
                        } else {
                            clusterState.put(node, "Observer");
                        }
                        ++i;
                    }
                    zkState.put("cluster", (Any)clusterState);
                }
            }
            catch (ClusterConfigException clusterConfigException) {}
        }
        return zkState;
    }

    @Override
    public boolean isOperational() {
        String myState = this._serverRunner.getServerState();
        if ("leaderelection".equals(myState)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            myState = this._serverRunner.getServerState();
            return !"leaderelection".equals(myState);
        }
        return true;
    }

    private boolean doCleanup() {
        boolean doCleanup = !this._clusterService.isResumeJobs();
        List<String> args = Arrays.asList(this._environmentInfo.getCommandLineArgs());
        if (!args.contains(ARG_DISCARD_JOBS) || !args.contains(ARG_RESUME_JOBS)) {
            if (args.contains(ARG_DISCARD_JOBS)) {
                doCleanup = true;
            } else if (args.contains(ARG_RESUME_JOBS)) {
                doCleanup = false;
            }
        }
        return doCleanup;
    }
}

