/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.CollatorSQLLongvarchar;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.StringUtil;

public class SQLLongvarchar
extends SQLVarchar {
    public String getTypeName() {
        return "LONG VARCHAR";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLLongvarchar(this.getString());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLLongvarchar();
    }

    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLLongvarchar s = new CollatorSQLLongvarchar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    public int getTypeFormatId() {
        return 235;
    }

    public SQLLongvarchar() {
    }

    public SQLLongvarchar(String val) {
        super(val);
    }

    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        if (sourceValue.length() > desiredType.getMaximumWidth()) {
            throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)StringUtil.formatForPrint(sourceValue), (Object)String.valueOf(desiredType.getMaximumWidth()));
        }
        this.setValue(sourceValue);
    }

    public StringDataValue concatenate(StringDataValue leftOperand, StringDataValue rightOperand, StringDataValue result) throws StandardException {
        super.concatenate(leftOperand, rightOperand, result);
        if (result.getString() != null && result.getString().length() > 32700) {
            throw StandardException.newException("54006", (Object)"CONCAT", (Object)String.valueOf(32700));
        }
        return result;
    }

    public int typePrecedence() {
        return 12;
    }
}

