/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class DMLStatementNode
extends StatementNode {
    ResultSetNode resultSet;

    DMLStatementNode() {
    }

    public void init(Object resultSet) {
        this.resultSet = (ResultSetNode)resultSet;
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultSet != null) {
            this.printLabel(depth, "resultSet: ");
            this.resultSet.treePrint(depth + 1);
        }
    }

    public ResultSetNode getResultSetNode() {
        return this.resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryTreeNode bind(DataDictionary dataDictionary) throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            this.bindTables(dataDictionary);
            this.bindExpressions();
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        return this;
    }

    public QueryTreeNode bindResultSetsWithTables(DataDictionary dataDictionary) throws StandardException {
        this.bindTables(dataDictionary);
        this.bindExpressionsWithTables();
        return this;
    }

    protected void bindTables(DataDictionary dataDictionary) throws StandardException {
        this.resultSet = this.resultSet.bindNonVTITables(dataDictionary, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.resultSet = this.resultSet.bindVTITables((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
    }

    protected void bindExpressions() throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressions(fromList);
        SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
    }

    protected void bindExpressionsWithTables() throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressionsWithTables(fromList);
        SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
    }

    int activationKind() {
        Vector parameterList = this.getCompilerContext().getParameterList();
        if (parameterList != null && parameterList.size() > 0) {
            return 2;
        }
        return 1;
    }

    public void optimizeStatement() throws StandardException {
        this.optimizeStatement(null, null);
    }

    protected void optimizeStatement(ValueNode offset, ValueNode fetchFirst) throws StandardException {
        this.resultSet = this.resultSet.preprocess(this.getCompilerContext().getNumTables(), null, null);
        this.resultSet = this.resultSet.optimize(this.getDataDictionary(), null, 1.0);
        this.resultSet = this.resultSet.modifyAccessPaths();
        if (offset != null || fetchFirst != null) {
            this.resultSet = this.wrapRowCountNode(this.resultSet, offset, fetchFirst);
        }
        if (this instanceof CursorNode) {
            ResultSetNode siChild = this.resultSet;
            ResultColumnList siRCList = this.resultSet.getResultColumns();
            ResultColumnList childRCList = siRCList.copyListAndObjects();
            this.resultSet.setResultColumns(childRCList);
            siRCList.genVirtualColumnNodes(this.resultSet, childRCList);
            this.resultSet = (ResultSetNode)this.getNodeFactory().getNode(123, this.resultSet, siRCList, null, this.getContextManager());
            if (siChild.getReferencedTableMap() != null) {
                this.resultSet.setReferencedTableMap((JBitSet)siChild.getReferencedTableMap().clone());
            }
        }
    }

    private ResultSetNode wrapRowCountNode(ResultSetNode resultSet, ValueNode offset, ValueNode fetchFirst) throws StandardException {
        ResultSetNode topRS = resultSet;
        ResultColumnList selectRCs = topRS.getResultColumns().copyListAndObjects();
        selectRCs.genVirtualColumnNodes(topRS, topRS.getResultColumns());
        return (RowCountNode)this.getNodeFactory().getNode(223, topRS, selectRCs, offset, fetchFirst, this.getContextManager());
    }

    public ResultDescription makeResultDescription() {
        ResultColumnDescriptor[] colDescs = this.resultSet.makeResultDescriptors();
        String statementType = this.statementToString();
        return this.getExecutionFactory().getResultDescription(colDescs, statementType);
    }

    void generateParameterValueSet(ActivationClassBuilder acb) throws StandardException {
        int numberOfParameters;
        Vector parameterList = this.getCompilerContext().getParameterList();
        int n = numberOfParameters = parameterList == null ? 0 : parameterList.size();
        if (numberOfParameters <= 0) {
            return;
        }
        ParameterNode.generateParameterValueSet(acb, numberOfParameters, parameterList);
    }

    public boolean isAtomic() throws StandardException {
        HasNodeVisitor visitor = new HasNodeVisitor(FromBaseTable.class, StaticMethodCallNode.class);
        this.accept(visitor);
        return visitor.hasNode();
    }

    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        if (this.resultSet != null && !v.stopTraversal()) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(v);
        }
        return this;
    }

    int getPrivType() {
        return 0;
    }
}

