/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public final class ChainAllocPageOperation
extends PhysicalPageOperation {
    protected long newAllocPageNum;
    protected long newAllocPageOffset;

    public ChainAllocPageOperation(AllocPage allocPage, long pageNumber, long pageOffset) throws StandardException {
        super(allocPage);
        this.newAllocPageNum = pageNumber;
        this.newAllocPageOffset = pageOffset;
    }

    public ChainAllocPageOperation() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeLong(out, this.newAllocPageNum);
        CompressedNumber.writeLong(out, this.newAllocPageOffset);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.newAllocPageNum = CompressedNumber.readLong(in);
        this.newAllocPageOffset = CompressedNumber.readLong(in);
    }

    public int getTypeFormatId() {
        return 97;
    }

    public final void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException {
        SanityManager.ASSERT(this.page instanceof AllocPage);
        ((AllocPage)this.page).chainNextAllocPage(instant, this.newAllocPageNum, this.newAllocPageOffset);
    }

    public void undoMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException {
        SanityManager.ASSERT(undoPage != null, "undo Page null");
        SanityManager.ASSERT(undoPage instanceof AllocPage, "undo Page is not an allocPage");
        ((AllocPage)undoPage).chainNextAllocPage(CLRInstant, -1L, 0L);
    }

    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) {
        SanityManager.THROWASSERT("cannot call restoreMe on BI_ChainAllocPageOperation");
    }

    public String toString() {
        String str = super.toString();
        str = str + " Chain new alloc page number " + this.newAllocPageNum + " at " + this.newAllocPageOffset + " to " + this.getPageId();
        return str;
    }
}

