/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.versions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.versions.VersionManager;
import org.eclipse.smila.versions.VersionProvider;

public class VersionManagerImpl
implements VersionManager {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Collection<VersionProvider> _versionProviders = new ArrayList<VersionProvider>();

    @Override
    public AnyMap getVersionInfos() {
        TreeMap sortedComponentVersions = new TreeMap();
        for (VersionProvider provider : this._versionProviders) {
            sortedComponentVersions.putAll(provider.getVersionInfo());
        }
        AnyMap versions = DataFactory.DEFAULT.createAnyMap();
        versions.putAll(sortedComponentVersions);
        return versions;
    }

    public void addVersionProvider(VersionProvider provider) {
        this._versionProviders.add(provider);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Added VersionProvider '" + provider.getClass().getSimpleName() + "' to " + this.getClass().getSimpleName()));
        }
    }

    public void removeVersionProvider(VersionProvider provider) {
        this._versionProviders.remove(provider);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Removed VersionProvider '" + provider.getClass().getSimpleName() + "' from " + this.getClass().getSimpleName()));
        }
    }
}

