/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.filter;

import java.io.InputStream;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.filter.RecordFilterLoadSaveException;
import org.eclipse.smila.datamodel.filter.RecordFilterNotFoundException;
import org.eclipse.smila.datamodel.filter.RecordFilterUtils;
import org.eclipse.smila.datamodel.filter.messages.Filter;
import org.eclipse.smila.datamodel.filter.messages.RecordFilters;

public class RecordFilterHelper {
    private final RecordFilters _filters;

    public RecordFilterHelper(InputStream inputStream) throws RecordFilterLoadSaveException {
        this._filters = RecordFilterUtils.unmarshall(inputStream);
    }

    public RecordFilterHelper(RecordFilters filters) {
        if (filters == null) {
            throw new IllegalArgumentException("filters parameter cannot be null!");
        }
        this._filters = filters;
    }

    public Record filter(Record record, String filterName) throws RecordFilterNotFoundException {
        Filter filter = RecordFilterUtils.findFilter(this._filters, filterName);
        return RecordFilterUtils.filter(filter, record);
    }

    public AnyMap filter(AnyMap metadataObject, String filterName, DataFactory factory) throws RecordFilterNotFoundException {
        Filter filter = RecordFilterUtils.findFilter(this._filters, filterName);
        return RecordFilterUtils.filter(filter, metadataObject, factory);
    }
}

