/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.ipc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.StoredAttachment;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.ipc.IpcFactory;
import org.eclipse.smila.ipc.IpcStreamReader;
import org.eclipse.smila.ipc.IpcToken;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.ipc.json.JsonFactory;

public class IpcRecordReader {
    private static final String ATTACHMENT_NAMES = "_attachmentNames";
    private final IpcAnyReader _ipcAnyReader = new IpcAnyReader();
    private final IpcFactory _binaryFactory = new BinaryFactory();
    private final IpcFactory _jsonFactory = new JsonFactory();

    public Record readBinaryObject(byte[] binary) throws IOException {
        Record record;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(binary);
            record = this.readBinaryStream(bais);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return record;
    }

    public Record readBinaryStream(InputStream stream) throws IOException {
        IpcStreamReader reader = this._binaryFactory.newStreamReader(stream);
        return this.readStream(reader);
    }

    public Record readJsonObject(String json) throws IOException {
        Record record;
        ByteArrayInputStream bais = null;
        try {
            Record record2;
            bais = new ByteArrayInputStream(json.getBytes("UTF-8"));
            record = record2 = this.readJsonStream(bais);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return record;
    }

    public Record readJsonStream(InputStream stream) throws IOException {
        IpcStreamReader reader = this._jsonFactory.newStreamReader(stream);
        try {
            Record record = this.readStream(reader);
            return record;
        }
        finally {
            reader.closeWithoutStream();
        }
    }

    public Record readStream(IpcStreamReader reader) throws IOException {
        IpcToken token = reader.nextToken();
        if (token == null) {
            return null;
        }
        if (token != IpcToken.OBJECT_START) {
            throw new IllegalStateException("Expected OBJECT_START Token; Token = " + token);
        }
        token = reader.nextToken();
        if (token != IpcToken.MAPPING_START) {
            throw new IllegalStateException("Expected MAPPING_START Token; Token = " + token);
        }
        AnyMap metadata = this._ipcAnyReader.readMap(reader);
        Record record = DataFactory.DEFAULT.createRecord();
        record.getMetadata().putAll(metadata);
        token = reader.nextToken();
        if (token == IpcToken.ATTACHMENTS_START) {
            this.readAttachments(reader, record);
            if (metadata.containsKey(ATTACHMENT_NAMES)) {
                metadata.remove(ATTACHMENT_NAMES);
            }
            token = reader.nextToken();
        } else if (metadata.containsKey(ATTACHMENT_NAMES)) {
            for (Any attName : metadata.getSeq(ATTACHMENT_NAMES)) {
                record.setAttachment(new StoredAttachment(attName.asValue().asString()));
            }
            record.getMetadata().remove(ATTACHMENT_NAMES);
        }
        if (token != IpcToken.OBJECT_END) {
            throw new IllegalStateException("Expected OBJECT_END Token; Token = " + token);
        }
        return record;
    }

    private void readAttachments(IpcStreamReader reader, Record record) throws IOException {
        IpcToken token;
        while ((token = reader.nextToken()) != IpcToken.ATTACHMENTS_END) {
            if (token != IpcToken.SCALAR_STRING) {
                throw new IllegalStateException("Expected SCALAR_STRING Token for attachment name; Token = " + token);
            }
            String attachmentName = reader.currentStringValue();
            token = reader.nextToken();
            if (token != IpcToken.BINARY) {
                throw new IllegalStateException("Expected BINARY Token; Token = " + token);
            }
            record.setAttachment(attachmentName, reader.currentBinaryValue());
        }
    }
}

