/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v2.InstanceGlobals;
import org.apache.ode.bpel.rtrep.v2.OPartnerLink;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScopeFrame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ScopeFrame.class);
    final OScope oscope;
    final ScopeFrame parent;
    final Long scopeInstanceId;
    Set<CompensationHandler> availableCompensations;
    private FaultData _faultData;
    final InstanceGlobals globals;

    ScopeFrame(OScope oScope, Long l, ScopeFrame scopeFrame, Set<CompensationHandler> set, FaultData faultData) {
        this(oScope, l, scopeFrame, set, scopeFrame.globals);
        this._faultData = faultData;
    }

    public ScopeFrame(OScope oScope, Long l, ScopeFrame scopeFrame, Set<CompensationHandler> set) {
        this(oScope, l, scopeFrame, set, scopeFrame.globals);
    }

    public ScopeFrame(OScope oScope, Long l, ScopeFrame scopeFrame, Set<CompensationHandler> set, InstanceGlobals instanceGlobals) {
        this.oscope = oScope;
        this.scopeInstanceId = l;
        this.parent = scopeFrame;
        this.availableCompensations = set;
        this.globals = instanceGlobals;
    }

    public ScopeFrame find(OScope oScope) {
        if (this.oscope.getId() == oScope.getId()) {
            return this;
        }
        return this.parent != null ? this.parent.find(oScope) : null;
    }

    public VariableInstance resolve(OScope.Variable variable) {
        ScopeFrame scopeFrame = this.find(variable.declaringScope);
        if (scopeFrame == null) {
            return null;
        }
        return new VariableInstance(scopeFrame.scopeInstanceId, variable);
    }

    public CorrelationSetInstance resolve(OScope.CorrelationSet correlationSet) {
        return new CorrelationSetInstance(this.find((OScope)correlationSet.declaringScope).scopeInstanceId, correlationSet);
    }

    public CorrelationSetInstance resolve(String string) {
        OScope.CorrelationSet correlationSet = this.oscope.getCorrelationSet(string);
        if (correlationSet != null) {
            return new CorrelationSetInstance(this.scopeInstanceId, correlationSet);
        }
        if (this.parent != null) {
            return this.parent.resolve(string);
        }
        return null;
    }

    public PartnerLinkInstance resolve(OPartnerLink oPartnerLink) {
        return new PartnerLinkInstance(this.find((OScope)oPartnerLink.declaringScope).scopeInstanceId, oPartnerLink);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{ScopeFrame: o=");
        stringBuffer.append(this.oscope);
        stringBuffer.append(", id=");
        stringBuffer.append(this.scopeInstanceId);
        if (this.availableCompensations != null) {
            stringBuffer.append(", avComps=");
            stringBuffer.append(this.availableCompensations);
        }
        if (this._faultData != null) {
            stringBuffer.append(", fault=");
            stringBuffer.append(this._faultData);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public FaultData getFault() {
        if (this._faultData != null) {
            return this._faultData;
        }
        if (this.parent != null) {
            return this.parent.getFault();
        }
        return null;
    }

    public void fillEventInfo(ScopeEvent scopeEvent) {
        ScopeFrame scopeFrame = this;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (scopeFrame != null) {
            arrayList.add(scopeFrame.oscope.name);
            scopeFrame = scopeFrame.parent;
        }
        scopeEvent.setParentScopesNames(arrayList);
        if (this.parent != null) {
            scopeEvent.setParentScopeId(this.parent.scopeInstanceId);
        }
        scopeEvent.setScopeId(this.scopeInstanceId);
        scopeEvent.setScopeName(this.oscope.name);
        scopeEvent.setScopeDeclerationId(this.oscope.getId());
        if (scopeEvent.getLineNo() == -1 && this.oscope.debugInfo != null) {
            scopeEvent.setLineNo(this.oscope.debugInfo.startLine);
        }
    }
}

