/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.bom;

import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.bom.BpelObject;
import org.apache.ode.bpel.rtrep.common.extension.ExtensibilityQNames;
import org.w3c.dom.Element;

public class Variable
extends BpelObject {
    public Variable(Element element) {
        super(element);
    }

    public String getName() {
        return this.getAttribute("name", null);
    }

    public QName getTypeName() {
        String string = null;
        switch (this.getKind()) {
            case MESSAGE: {
                string = this.getAttribute("messageType", null);
                break;
            }
            case SCHEMA: {
                string = this.getAttribute("type", null);
                break;
            }
            case ELEMENT: {
                string = this.getAttribute("element", null);
            }
        }
        if (string == null) {
            return null;
        }
        return this.getNamespaceContext().derefQName(string);
    }

    public Kind getKind() {
        if (this.getAttribute("messageType", null) != null) {
            return Kind.MESSAGE;
        }
        if (this.getAttribute("type", null) != null) {
            return Kind.SCHEMA;
        }
        if (this.getAttribute("element", null) != null) {
            return Kind.ELEMENT;
        }
        return null;
    }

    public String getExternalId() {
        return this.getAttribute(ExtensibilityQNames.EXTVAR_ATTR, null);
    }

    public boolean isExternal() {
        return null != this.getExternalId();
    }

    public String getRelated() {
        return this.getAttribute(ExtensibilityQNames.EXTVAR_RELATED, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        SCHEMA,
        ELEMENT,
        MESSAGE;

    }
}

