/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.JobRun;
import org.eclipse.smila.jobmanager.JobRunEngine;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.jobmanager.JobTaskProcessor;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkflowAction;
import org.eclipse.smila.jobmanager.exceptions.IllegalJobStateException;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.exceptions.NoSuchTaskGeneratorException;
import org.eclipse.smila.jobmanager.internal.ExpressionUtil;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.jobmanager.persistence.RunStorageException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerationUtil;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorBase;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorProvider;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.ServiceUnavailableException;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.taskworker.output.OutputMode;
import org.eclipse.smila.utils.collections.MultiValueMap;
import org.osgi.service.component.ComponentContext;

public class JobTaskProcessorImpl
implements JobTaskProcessor {
    private static final long MIN_TASK_GENERATION_TIME_TO_LOG = 1000L;
    private final Log _log = LogFactory.getLog(this.getClass());
    private DefinitionPersistence _defPersistence;
    private RunStorage _runStorage;
    private TaskManager _taskManager;
    private ClusterConfigService _clusterConfigService;
    private ObjectStoreService _objectStore;
    private TaskGeneratorProvider _taskGeneratorProvider;
    private JobRunEngine _runEngine;

    protected void activate(ComponentContext context) {
        Collection<String> workers = this._defPersistence.getWorkers();
        for (String worker : workers) {
            try {
                this._taskManager.addTaskQueue(worker);
            }
            catch (TaskmanagerException ex) {
                this._log.warn((Object)("Error creating task queue for worker '" + worker + "'"), (Throwable)ex);
            }
        }
    }

    @Override
    public List<Task> finishTask(Task currentTask) throws JobManagerException {
        ResultDescription resultDescription = currentTask.getResultDescription();
        String workflowRunId = (String)currentTask.getProperties().get("workflowRunId");
        String jobRunId = (String)currentTask.getProperties().get("jobRunId");
        String jobName = (String)currentTask.getProperties().get("jobName");
        String workerName = this.getOriginalWorkerName(currentTask);
        try {
            if (!this._runStorage.hasTask(jobName, workflowRunId, currentTask.getTaskId())) {
                throw new IllegalJobStateException("Task '" + currentTask.getTaskId() + "' for job '" + jobName + "' and run '" + jobRunId + "' is unknown, maybe already finished or workflow run was canceled.");
            }
            try {
                ArrayList<Task> followUpTasks = new ArrayList<Task>();
                switch (resultDescription.getStatus()) {
                    case SUCCESSFUL: {
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("Successfully handles task '" + currentTask.getTaskId() + "' of worker '" + workerName + "' in job run '" + jobRunId + "' of job '" + jobName + "'"));
                        }
                        followUpTasks.addAll(this.handleSuccessfulTask(jobName, jobRunId, workflowRunId, workerName, currentTask, resultDescription.getCounters()));
                        break;
                    }
                    case OBSOLETE: {
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("Obsolete task '" + currentTask.getTaskId() + "' of worker '" + workerName + "' in job run '" + jobRunId + "' of job '" + jobName + "'"));
                        }
                        this.handleObsoleteTask(jobName, jobRunId, workflowRunId, workerName, currentTask);
                        break;
                    }
                    case RECOVERABLE_ERROR: {
                        this._log.warn((Object)("A recoverable error '" + resultDescription.getErrorCode() + "'('" + resultDescription.getErrorMessage() + "') occurred in processing of task '" + currentTask.getTaskId() + "' for worker '" + workerName + "'"));
                        followUpTasks.addAll(this.handleRecoverableTaskError(jobName, jobRunId, workflowRunId, workerName, currentTask, resultDescription));
                        break;
                    }
                    default: {
                        this._log.error((Object)("A fatal error '" + resultDescription.getErrorCode() + "'('" + resultDescription.getErrorMessage() + "') occurred in processing of task " + currentTask.getTaskId() + " of worker " + workerName + ". Workflow run '" + workflowRunId + "' will be marked as failed, its tasks will be canceled."));
                        this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, currentTask, false);
                    }
                }
                ArrayList<Task> arrayList = followUpTasks;
                return arrayList;
            }
            catch (JobManagerException jme) {
                if (resultDescription.getStatus() != TaskCompletionStatus.FATAL_ERROR && !jme.isRecoverable()) {
                    try {
                        this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, currentTask, false);
                    }
                    catch (JobManagerException e) {
                        this._log.error((Object)"Exception while handling fatal error during nonrecoverable finishing exception.", (Throwable)((Object)e));
                    }
                }
                throw jme;
            }
        }
        finally {
            try {
                if (this.checkAndHandleWorkflowRunCompleted(jobName, jobRunId, workflowRunId)) {
                    this._runEngine.checkAndHandleJobRunCompleted(jobName, jobRunId);
                }
            }
            catch (JobManagerException e) {
                this._log.error((Object)"Exception while checking workflow/job run completion.", (Throwable)((Object)e));
                throw new JobManagerException("Exception while checking workflow/job run completion.", (Throwable)((Object)e), true);
            }
        }
    }

    @Override
    public Task getInitialTask(String workerName, String jobName) throws JobManagerException {
        String jobRunId = null;
        String workflowRunId = null;
        Task task = null;
        jobRunId = this._runStorage.getJobRunId(jobName);
        if (jobRunId == null || !this.checkJobStateForTaskCreation(jobName, jobRunId, true)) {
            throw new IllegalJobStateException("Job with name '" + jobName + "' is not running or is already finishing.");
        }
        JobRun jobRun = this._runEngine.ensureJobRun(jobName, jobRunId);
        try {
            workflowRunId = this._runStorage.startWorkflowRun(jobName, jobRunId);
            task = this.getInitialTask(jobRun, workerName, workflowRunId);
            task.getProperties().put("recoverable", Boolean.toString(Boolean.FALSE));
            this._runStorage.startTask(jobName, jobRunId, workflowRunId, workerName, task.getTaskId());
            this._taskManager.addInProgressTask(task);
            return task;
        }
        catch (Exception e) {
            this.cleanupFailedWorkflowRun(jobName, jobRunId, workflowRunId, workerName, task);
            throw new JobManagerException("Getting initial task failed for worker '" + workerName + "' for job '" + jobName + "' due to error.", e);
        }
    }

    private String getOriginalWorkerName(Task currentTask) {
        return (String)currentTask.getProperties().get("originalWorker");
    }

    protected List<Task> handleSuccessfulTask(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask, Map<String, Number> workerCounter) throws JobManagerException {
        ArrayList<Task> followUpTasks = new ArrayList<Task>();
        try {
            JobRun jobRun = this._runEngine.ensureJobRun(jobName, jobRunId);
            WorkerDefinition worker = this._defPersistence.getWorker(workerName);
            if (!this.checkJobStateForTaskFinishing(jobName, jobRunId, currentTask.getProperties().containsKey("isCompletingTask"))) {
                throw new IllegalJobStateException("Could not finish Task. Job with name'" + jobName + "' is not running or is already completed.");
            }
            this.adaptBulksForMultipleOutputSlots(currentTask, workerName);
            if (this.checkJobStateForTaskCreation(jobName, jobRunId, false)) {
                followUpTasks.addAll(this.createFollowUpTasks(currentTask, jobRun, workflowRunId));
                for (Task newTask : followUpTasks) {
                    String newTaskJobName = (String)newTask.getProperties().get("jobName");
                    String newTaskJobRunId = (String)newTask.getProperties().get("jobRunId");
                    String newTaskWfRunId = (String)newTask.getProperties().get("workflowRunId");
                    this._runStorage.startTask(newTaskJobName, newTaskJobRunId, newTaskWfRunId, newTask.getWorkerName(), newTask.getTaskId());
                    this._taskManager.addTask(newTask);
                }
            }
            this.notifyTaskGenerator(worker, currentTask, TaskCompletionStatus.SUCCESSFUL);
            this._runStorage.finishTask(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId(), workerCounter, currentTask.getProperties());
        }
        catch (NoSuchTaskGeneratorException e) {
            throw new JobManagerException("Could not find task generator while handling successful task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e, true);
        }
        catch (Exception e) {
            throw new JobManagerException("Error while handling successful task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e);
        }
        return followUpTasks;
    }

    protected void handleObsoleteTask(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask) throws JobManagerException {
        try {
            WorkerDefinition worker = this._defPersistence.getWorker(workerName);
            if (!this.checkJobStateForTaskCreation(jobName, jobRunId, false)) {
                throw new IllegalJobStateException("Could not finish obsolete task '" + currentTask.getTaskId() + "'. Job with name'" + jobName + "' is not running or is already completed.");
            }
            this.notifyTaskGenerator(worker, currentTask, TaskCompletionStatus.OBSOLETE);
            this._runStorage.obsoleteTask(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId(), currentTask.getProperties());
        }
        catch (Exception e) {
            throw new JobManagerException("Error while handling obsolete task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e);
        }
    }

    protected List<Task> handleRecoverableTaskError(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask, ResultDescription resultDescription) throws JobManagerException {
        ArrayList<Task> followUpTasks = new ArrayList<Task>();
        try {
            WorkerDefinition worker = this._defPersistence.getWorker(workerName);
            if (worker == null) {
                throw new JobManagerException("Worker '" + workerName + "' not found while handling recoverable task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.");
            }
            if (worker.getModes().contains((Object)WorkerDefinition.Mode.AUTOCOMMIT)) {
                this.handleRecoverableTaskWithAutocommit(jobName, jobRunId, workflowRunId, workerName, currentTask, resultDescription, followUpTasks);
            } else if (currentTask.getProperties().containsKey("recoverable") && !Boolean.valueOf((String)currentTask.getProperties().get("recoverable")).booleanValue()) {
                this._log.warn((Object)("Could not retry failed task '" + currentTask.getTaskId() + "' cause it's not recoverable."));
                this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, currentTask, false);
            } else {
                int numberOfRetries = this._runStorage.getTaskRetries(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId()) + 1;
                if ((long)numberOfRetries <= this._clusterConfigService.getMaxRetries()) {
                    Task retryTask = currentTask.createRetryTask(TaskGeneratorBase.createTaskId());
                    this._taskManager.addTask(retryTask);
                    this._runStorage.startTask(jobName, jobRunId, workflowRunId, retryTask.getWorkerName(), retryTask.getTaskId(), numberOfRetries);
                    followUpTasks.add(retryTask);
                    this._runStorage.retriedTask(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId(), !"TimeToLive".equals(resultDescription.getErrorCode()), currentTask.getProperties());
                } else {
                    this._log.error((Object)("Could not retry failed recoverable task '" + currentTask.getTaskId() + "' , because maximum number of retries was reached."));
                    this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, currentTask, true);
                }
            }
        }
        catch (Exception e) {
            throw new JobManagerException("Error while handling recoverable task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e);
        }
        return followUpTasks;
    }

    protected void handleRecoverableTaskWithAutocommit(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask, ResultDescription resultDescription, List<Task> followUpTasks) throws JobManagerException {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Task '" + currentTask.getTaskId() + "' of autocommit worker '" + workerName + "' in job '" + jobName + "' failed with an recoverable error: finishing it as successful."));
        }
        for (Map.Entry entry : currentTask.getOutputBulks().entrySet()) {
            for (BulkInfo bulkInfo : (List)entry.getValue()) {
                String storeName = bulkInfo.getStoreName();
                String objectId = bulkInfo.getObjectName();
                try {
                    if (!ObjectStoreRetryUtil.retryExistsObject((ObjectStoreService)this._objectStore, (String)storeName, (String)objectId)) continue;
                    this._objectStore.finishObject(storeName, objectId);
                }
                catch (ServiceUnavailableException ex) {
                    this._log.warn((Object)("Error finishing object '" + objectId + "' in store '" + storeName + "', retrying."), (Throwable)ex);
                    throw new JobManagerException("Could not finish object '" + objectId + "' in store '" + storeName + "'.", ex);
                }
                catch (Exception ex) {
                    this._log.warn((Object)("Error finishing object '" + objectId + "' in store '" + storeName + "', ignoring and continuing."), (Throwable)ex);
                }
            }
        }
        followUpTasks.addAll(this.handleSuccessfulTask(jobName, jobRunId, workflowRunId, workerName, currentTask, resultDescription.getCounters()));
    }

    protected void handleFatalError(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask, boolean failedAfterRetry) throws JobManagerException {
        try {
            try {
                WorkerDefinition worker = this._defPersistence.getWorker(workerName);
                if (worker == null) {
                    throw new JobManagerException("Worker '" + workerName + "' not found while handling fatal error task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.");
                }
                this.notifyTaskGenerator(worker, currentTask, TaskCompletionStatus.FATAL_ERROR);
            }
            finally {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Workflow run '" + workflowRunId + "' failed, preparing finish"));
                }
                boolean doIt = this._runStorage.prepareToFinishWorkflowRun(jobName, jobRunId, workflowRunId);
                try {
                    this._runStorage.failedTask(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId(), failedAfterRetry, currentTask.getProperties());
                }
                catch (Exception e) {
                    if (doIt) {
                        this._log.warn((Object)("Error while failing task '" + currentTask.getTaskId() + "' for workflow run '" + workflowRunId + "'"));
                    }
                    throw e;
                }
                if (doIt) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Workflow run '" + workflowRunId + "' failed, aggregating counters"));
                    }
                    this._runStorage.failedWorkflowRun(jobName, jobRunId, workflowRunId);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Workflow run '" + workflowRunId + "' failed, deleting transient bulks"));
                    }
                    this._runEngine.deleteTransientBulks(jobName, jobRunId, workflowRunId);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Workflow run '" + workflowRunId + "' failed, deleting data"));
                    }
                    this._runStorage.deleteWorkflowRunData(jobName, jobRunId, workflowRunId);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Workflow run '" + workflowRunId + "' failed, deleting workflow run"));
                    }
                    this._runStorage.deleteWorkflowRun(jobName, jobRunId, workflowRunId);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Workflow run '" + workflowRunId + "' failed, checking job run completion"));
                    }
                    this._runEngine.checkAndHandleJobRunCompleted(jobName, jobRunId);
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Workflow run '" + workflowRunId + "' failed"));
                }
            }
        }
        catch (Exception e) {
            throw new JobManagerException("Error while handling failed task in workflow run '" + workflowRunId + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e);
        }
    }

    private boolean checkAndHandleWorkflowRunCompleted(String jobName, String jobRunId, String workflowRunId) throws JobManagerException {
        boolean completed = this.isWorkflowRunCompleted(jobName, jobRunId, workflowRunId);
        if (completed) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Workflow run '" + workflowRunId + "' completed, deleting transient bulks"));
            }
            this._runEngine.deleteTransientBulks(jobName, jobRunId, workflowRunId);
            if (this._runStorage.hasWorkflowRun(jobName, jobRunId, workflowRunId)) {
                boolean doIt;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Workflow run '" + workflowRunId + "' completed, preparing finish"));
                }
                if (doIt = this._runStorage.prepareToFinishWorkflowRun(jobName, jobRunId, workflowRunId)) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Workflow run '" + workflowRunId + "' completed, aggregating counters"));
                    }
                    this._runStorage.successfulWorkflowRun(jobName, jobRunId, workflowRunId);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Workflow run '" + workflowRunId + "' completed, deleting data"));
                    }
                    this._runStorage.deleteWorkflowRunData(jobName, jobRunId, workflowRunId);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Workflow run '" + workflowRunId + "' completed, deleting workflow run"));
                    }
                    this._runStorage.deleteWorkflowRun(jobName, jobRunId, workflowRunId);
                }
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Workflow run '" + workflowRunId + "' completed"));
            }
        }
        return completed;
    }

    private boolean checkJobStateForTaskCreation(String jobName, String jobRunId, boolean isInitialTask) throws RunStorageException {
        JobState jobState = this._runStorage.getJobState(jobName, jobRunId);
        if (jobState == JobState.RUNNING) {
            return true;
        }
        return !isInitialTask && jobState == JobState.FINISHING;
    }

    private boolean checkJobStateForTaskFinishing(String jobName, String jobRunId, boolean isCompletingTasks) throws RunStorageException {
        JobState jobState = this._runStorage.getJobState(jobName, jobRunId);
        return jobState == JobState.RUNNING || jobState == JobState.FINISHING || jobState == JobState.COMPLETING && isCompletingTasks;
    }

    private void adaptBulksForMultipleOutputSlots(Task currentTask, String workerName) throws JobManagerException {
        WorkerDefinition workerDef = this._defPersistence.getWorker(workerName);
        for (String slotName : currentTask.getOutputBulks().keySet()) {
            if (workerDef == null || workerDef.getOutputModes() == null || workerDef.getOutputModes().get(slotName) == null || !workerDef.getOutputModes().get(slotName).contains(OutputMode.MULTIPLE)) continue;
            List taskBulks = (List)currentTask.getOutputBulks().get(slotName);
            BulkInfo template = (BulkInfo)taskBulks.get(0);
            String objectNamePrefix = template.getObjectName();
            try {
                Collection objects = ObjectStoreRetryUtil.retryGetStoreObjectInfos((ObjectStoreService)this._objectStore, (String)template.getStoreName(), (String)objectNamePrefix);
                taskBulks.clear();
                for (StoreObject o : objects) {
                    BulkInfo info = new BulkInfo(template.getBucketName(), template.getStoreName(), o.getId());
                    taskBulks.add(info);
                }
            }
            catch (ObjectStoreException e) {
                throw new JobManagerException("Error while adapting output bulks for multiple output slots", e);
            }
        }
    }

    private List<Task> createFollowUpTasks(Task currentTask, JobRun jobRun, String workflowRunId) throws JobManagerException {
        MultiValueMap<String, BulkInfo> bucketNameToCreatedBulksMap = this.checkOutputBulksForCreation(jobRun, currentTask);
        ArrayList<JobRun> triggeredJobs = new ArrayList<JobRun>();
        for (Map.Entry bucketToBulksEntry : bucketNameToCreatedBulksMap.entrySet()) {
            String bucketName = (String)bucketToBulksEntry.getKey();
            if (jobRun.getBucket(bucketName).isPersistent()) {
                triggeredJobs.addAll(this.getJobsTriggeredByBucket(jobRun, bucketName));
                continue;
            }
            this.storeTransientBulks(jobRun, workflowRunId, (List)bucketToBulksEntry.getValue());
        }
        AnyMap taskParamsToCopy = this.getTaskParametersToCopy(currentTask);
        List<Task> followUpTasks = this.getFollowupTasks(jobRun, workflowRunId, bucketNameToCreatedBulksMap, taskParamsToCopy);
        for (JobRun triggeredJob : triggeredJobs) {
            try {
                List<Task> triggeredTasks = this.getTriggeredInitialTasks(triggeredJob, bucketNameToCreatedBulksMap);
                if (triggeredTasks.isEmpty()) continue;
                String triggeredJobWorkflowRunId = this._runStorage.startWorkflowRun(triggeredJob.getJobName(), triggeredJob.getJobRunId());
                for (Task task : triggeredTasks) {
                    task.getProperties().put("workflowRunId", triggeredJobWorkflowRunId);
                }
                followUpTasks.addAll(triggeredTasks);
            }
            catch (Exception e) {
                this._log.error((Object)("Tried to create tasks for potentially triggered jobs, but got an error. Job '" + triggeredJob.getJobName() + "' will not be triggered."), (Throwable)e);
            }
        }
        return followUpTasks;
    }

    private void notifyTaskGenerator(WorkerDefinition worker, Task task, TaskCompletionStatus status) throws TaskGeneratorException {
        TaskGenerator taskGenerator = this._taskGeneratorProvider.getTaskGenerator(worker);
        taskGenerator.finishTask(task, status);
    }

    private boolean isWorkflowRunCompleted(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        return !this._runStorage.hasTasks(jobName, jobRunId, workflowRunId);
    }

    private MultiValueMap<String, BulkInfo> checkOutputBulksForCreation(JobRun jobRun, Task task) throws JobManagerException {
        WorkerDefinition workerDef = this._defPersistence.getWorker(this.getOriginalWorkerName(task));
        MultiValueMap outputBulkMap = new MultiValueMap();
        for (Map.Entry currentEntry : task.getOutputBulks().entrySet()) {
            String currentSlotName = (String)currentEntry.getKey();
            boolean maybeEmpty = workerDef.getOutput(currentSlotName).getModes().contains(OutputMode.MAYBEEMPTY);
            for (BulkInfo bulkInfo : (List)currentEntry.getValue()) {
                String storeName = bulkInfo.getStoreName();
                String objectName = bulkInfo.getObjectName();
                try {
                    if (!ObjectStoreRetryUtil.retryExistsObject((ObjectStoreService)this._objectStore, (String)storeName, (String)objectName)) {
                        if (maybeEmpty) continue;
                        throw new JobManagerException("Output bulk '" + objectName + "' in bucket '" + bulkInfo.getBucketName() + "' of worker '" + workerDef.getName() + "' (job '" + jobRun.getJobName() + "') has not been created but must not be empty.");
                    }
                    outputBulkMap.add((Object)bulkInfo.getBucketName(), (Object)bulkInfo);
                }
                catch (Exception e) {
                    throw new JobManagerException(String.valueOf(e.getClass().getName()) + " occurred while checking output buckets.", e);
                }
            }
        }
        return outputBulkMap;
    }

    private Collection<JobRun> getJobsTriggeredByBucket(JobRun triggeringJobRun, String bucketName) throws JobManagerException {
        Bucket triggeringBucket = triggeringJobRun.getBucket(bucketName);
        Collection<String> jobNames = this._runStorage.getTriggeredJobs(triggeringBucket.getBucketId());
        jobNames.remove(triggeringJobRun.getJobName());
        ArrayList<JobRun> triggeredJobs = new ArrayList<JobRun>();
        for (String jobName : jobNames) {
            try {
                String jobRunId;
                JobRun jobRun;
                JobRunInfo runInfo = this._runStorage.getJobRunInfo(jobName);
                if (runInfo == null || runInfo.getState() != JobState.RUNNING || !(jobRun = this._runEngine.ensureJobRun(jobName, jobRunId = runInfo.getId())).isTriggeredBy(triggeringBucket)) continue;
                triggeredJobs.add(jobRun);
            }
            catch (Exception e) {
                this._log.warn((Object)("Tried to check potentially triggered jobs, but got an error. Job '" + jobName + "' will not be triggered."), (Throwable)e);
            }
        }
        return triggeredJobs;
    }

    private void storeTransientBulks(JobRun jobRun, String workflowRunId, List<BulkInfo> transientBulks) throws RunStorageException {
        String jobName = jobRun.getJobName();
        String jobRunId = jobRun.getJobRunId();
        for (BulkInfo bulkInfo : transientBulks) {
            this._runStorage.addTransientBulk(jobName, jobRunId, workflowRunId, String.valueOf(bulkInfo.getStoreName()) + "/" + bulkInfo.getObjectName());
        }
    }

    private AnyMap getTaskParametersToCopy(Task currentTask) {
        AnyMap taskParams = currentTask.getParameters();
        AnyMap paramsToCopy = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry param : taskParams.entrySet()) {
            if (!((String)param.getKey()).startsWith("_")) continue;
            paramsToCopy.put((String)param.getKey(), (Any)param.getValue());
        }
        return paramsToCopy;
    }

    private void cleanupFailedWorkflowRun(String jobName, String jobRunId, String workerName, String workflowRunId, Task task) {
        if (jobRunId != null && workflowRunId != null) {
            try {
                this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, task, false);
            }
            catch (Exception ex) {
                this._log.error((Object)("Error during cleanup of failed new workflow run '" + jobRunId + "' for job '" + jobName + "'."), (Throwable)ex);
            }
        }
    }

    private Task getInitialTask(JobRun jobRun, String workerName, String workflowRunId) throws JobManagerException {
        WorkflowAction startAction = jobRun.getStartAction();
        if (startAction == null || !workerName.equals(startAction.getWorker()) || !this._defPersistence.getWorker(workerName).getModes().contains((Object)WorkerDefinition.Mode.BULKSOURCE)) {
            throw new JobManagerException("Worker '" + workerName + "' is not defined as start action for job '" + jobRun.getJobName() + "' or has no '" + WorkerDefinition.Mode.BULKSOURCE.toString() + "' mode.");
        }
        List<Task> taskList = this.generateTasksForAction(jobRun, workflowRunId, (MultiValueMap<String, BulkInfo>)new MultiValueMap(), startAction, null);
        if (taskList.size() != 1) {
            throw new JobManagerException("Not exactly one initial task produced for worker '" + workerName + "' in workflow run '" + workflowRunId + "'.");
        }
        return taskList.get(0);
    }

    private List<Task> getTriggeredInitialTasks(JobRun jobRun, MultiValueMap<String, BulkInfo> bucketNameToReallyCreatedBulksMap) throws JobManagerException {
        return this.generateTasksForAction(jobRun, null, bucketNameToReallyCreatedBulksMap, jobRun.getStartAction(), null);
    }

    private List<Task> getFollowupTasks(JobRun jobRun, String workflowRunId, MultiValueMap<String, BulkInfo> bucketNameToReallyCreatedBulksMap, AnyMap taskParamsToCopy) throws TaskGeneratorException {
        ArrayList<Task> followUpTasks = new ArrayList<Task>();
        Collection<WorkflowAction> followUpActions = this.getFollowupWorkflowActions(jobRun, bucketNameToReallyCreatedBulksMap.keySet());
        for (WorkflowAction action : followUpActions) {
            followUpTasks.addAll(this.generateTasksForAction(jobRun, workflowRunId, bucketNameToReallyCreatedBulksMap, action, taskParamsToCopy));
        }
        return followUpTasks;
    }

    private Collection<WorkflowAction> getFollowupWorkflowActions(JobRun jobRun, Collection<String> bucketNames) {
        HashSet<WorkflowAction> followUpActions = new HashSet<WorkflowAction>();
        for (String bucketName : bucketNames) {
            Collection<WorkflowAction> actions = jobRun.getTriggeredActionsForBucket(bucketName);
            if (actions == null) continue;
            followUpActions.addAll(actions);
        }
        return followUpActions;
    }

    private List<Task> generateTasksForAction(JobRun jobRun, String workflowRunId, MultiValueMap<String, BulkInfo> bucketNameToReallyCreatedBulksMap, WorkflowAction action, AnyMap taskParamsToCopy) throws TaskGeneratorException {
        WorkerDefinition workerDef = this._defPersistence.getWorker(action.getWorker());
        TaskGenerator taskGenerator = this._taskGeneratorProvider.getTaskGenerator(workerDef);
        AnyMap paramExpressions = DataFactory.DEFAULT.createAnyMap();
        if (jobRun.getParameters() != null) {
            paramExpressions.putAll((Map)jobRun.getParameters());
        }
        if (action.getParameters() != null) {
            paramExpressions.putAll((Map)action.getParameters());
        }
        AnyMap parameters = ExpressionUtil.evaluateParameters(paramExpressions);
        if (taskParamsToCopy != null) {
            parameters.putAll((Map)taskParamsToCopy);
        }
        Map<String, Bucket> inputSlotNameToBucket = jobRun.getInputBucketsForAction(action);
        Map<String, Bucket> outputSlotNameToBucketMap = jobRun.getOutputBucketsForAction(action);
        MultiValueMap<String, BulkInfo> changedInputSlotToBulkListMap = this.prepareInputSlots(action, bucketNameToReallyCreatedBulksMap);
        long start = System.currentTimeMillis();
        List<Task> tasks = taskGenerator.createTasks((Map<String, List<BulkInfo>>)changedInputSlotToBulkListMap, inputSlotNameToBucket, outputSlotNameToBucketMap, parameters, action.getWorker());
        long t = System.currentTimeMillis() - start;
        if (t > 1000L && this._log.isInfoEnabled()) {
            this._log.info((Object)("TaskGenerator '" + taskGenerator.getName() + "' time for creating tasks: " + t));
        }
        TaskGenerationUtil.setAdditionalTaskProperties(tasks, jobRun, workflowRunId, workerDef);
        return tasks;
    }

    private MultiValueMap<String, BulkInfo> prepareInputSlots(WorkflowAction action, MultiValueMap<String, BulkInfo> bucketNameToReallyCreatedBulksMap) {
        MultiValueMap changedInputSlotToBulkListMap = new MultiValueMap();
        Map<String, String> actionInput = action.getInput();
        if (actionInput != null) {
            for (Map.Entry<String, String> actionInputEntry : actionInput.entrySet()) {
                List bulkInfoList = (List)bucketNameToReallyCreatedBulksMap.get((Object)actionInputEntry.getValue());
                if (bulkInfoList == null) continue;
                for (BulkInfo inputBulk : bulkInfoList) {
                    if (inputBulk == null) continue;
                    if (!changedInputSlotToBulkListMap.containsKey((Object)actionInputEntry.getKey())) {
                        changedInputSlotToBulkListMap.put((Object)actionInputEntry.getKey(), new ArrayList());
                    }
                    ((List)changedInputSlotToBulkListMap.get((Object)actionInputEntry.getKey())).add(inputBulk);
                }
            }
        }
        return changedInputSlotToBulkListMap;
    }

    public void setDefinitionPersistence(DefinitionPersistence defPersistence) {
        this._defPersistence = defPersistence;
    }

    public void unsetDefinitionPersistence(DefinitionPersistence defPersistence) {
        if (this._defPersistence == defPersistence) {
            this._defPersistence = null;
        }
    }

    public void setRunStorage(RunStorage runStorage) {
        this._runStorage = runStorage;
    }

    public void unsetRunStorage(RunStorage runStorage) {
        if (this._runStorage == runStorage) {
            this._runStorage = null;
        }
    }

    public void setObjectStoreService(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }

    public void setTaskGeneratorProvider(TaskGeneratorProvider taskGeneratorProvider) {
        this._taskGeneratorProvider = taskGeneratorProvider;
    }

    public void unsetTaskGeneratorProvider(TaskGeneratorProvider taskGeneratorProvider) {
        if (this._taskGeneratorProvider == taskGeneratorProvider) {
            this._taskGeneratorProvider = null;
        }
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }

    public void setClusterConfigService(ClusterConfigService clusterConfigService) {
        this._clusterConfigService = clusterConfigService;
    }

    public void unsetClusterConfigService(ClusterConfigService clusterConfigService) {
        if (this._clusterConfigService == clusterConfigService) {
            this._clusterConfigService = null;
        }
    }

    public void setJobRunEngine(JobRunEngine runEngine) {
        this._runEngine = runEngine;
    }

    public void unsetJobRunEngine(JobRunEngine runEngine) {
        if (this._runEngine == runEngine) {
            this._runEngine = null;
        }
    }
}

