/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.persistence;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.jobmanager.definitions.JobRunDefinitions;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.jobmanager.persistence.JobRunListener;
import org.eclipse.smila.jobmanager.persistence.RunStorageException;
import org.eclipse.smila.taskmanager.Task;

public interface RunStorage {
    public void clear() throws RunStorageException;

    public void startJobRun(String var1, String var2, JobRunMode var3, JobRunDefinitions var4) throws RunStorageException;

    public boolean finishJobRun(String var1, String var2) throws RunStorageException;

    public void deleteJobRun(String var1, String var2) throws RunStorageException;

    public List<String> cancelJobRun(String var1, String var2) throws RunStorageException;

    public Collection<String> getCurrentJobs() throws RunStorageException;

    public String getJobRunId(String var1) throws RunStorageException;

    public AnyMap getJobRunData(String var1, boolean var2) throws RunStorageException;

    public AnyMap getWorkflowRunData(String var1, String var2) throws RunStorageException;

    public void setJobState(String var1, String var2, JobState var3) throws RunStorageException;

    public boolean setJobState(String var1, String var2, JobState var3, JobState var4) throws RunStorageException;

    public JobState getJobState(String var1) throws RunStorageException;

    public JobState getJobState(String var1, String var2) throws RunStorageException;

    public JobRunInfo getJobRunInfo(String var1) throws RunStorageException;

    public String startWorkflowRun(String var1, String var2) throws RunStorageException;

    public String startCompletionWorkflowRun(String var1, String var2) throws RunStorageException;

    public boolean prepareToFinishWorkflowRun(String var1, String var2, String var3) throws RunStorageException;

    public void successfulWorkflowRun(String var1, String var2, String var3) throws RunStorageException;

    public void failedWorkflowRun(String var1, String var2, String var3) throws RunStorageException;

    public void deleteWorkflowRunData(String var1, String var2, String var3) throws RunStorageException;

    public void deleteWorkflowRun(String var1, String var2, String var3) throws RunStorageException;

    public boolean checkAndCleanupActiveWorkflowRuns(String var1, String var2) throws RunStorageException;

    public boolean hasWorkflowRun(String var1, String var2, String var3) throws RunStorageException;

    public boolean hasTasks(String var1, String var2, String var3) throws RunStorageException;

    public void startTask(String var1, String var2, String var3, String var4, String var5) throws RunStorageException;

    public void startTask(String var1, String var2, String var3, String var4, String var5, int var6) throws RunStorageException;

    public void startTasks(String var1, String var2, String var3, Collection<Task> var4) throws RunStorageException;

    public int getTaskRetries(String var1, String var2, String var3, String var4, String var5) throws RunStorageException;

    public void finishTask(String var1, String var2, String var3, String var4, String var5, Map<String, Number> var6, Map<String, String> var7) throws RunStorageException;

    public void obsoleteTask(String var1, String var2, String var3, String var4, String var5, Map<String, String> var6) throws RunStorageException;

    public void retriedTask(String var1, String var2, String var3, String var4, String var5, boolean var6, Map<String, String> var7) throws RunStorageException;

    public void failedTask(String var1, String var2, String var3, String var4, String var5, boolean var6, Map<String, String> var7) throws RunStorageException;

    public void addTransientBulk(String var1, String var2, String var3, String var4) throws RunStorageException;

    public Collection<String> getTransientBulks(String var1, String var2, String var3) throws RunStorageException;

    public Collection<String> getTriggeredJobs(String var1) throws RunStorageException;

    public void addJobTrigger(String var1, String var2) throws RunStorageException;

    public void removeJobTrigger(String var1, String var2) throws RunStorageException;

    public boolean hasTask(String var1, String var2, String var3) throws RunStorageException;

    public String getCurrentTimestamp();

    public void registerJobRunListener(JobRunListener var1, String var2);
}

