/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPNameFormSchema
extends LDAPSchemaElement {
    private String objectClass;
    private String[] required;
    private String[] optional;

    public LDAPNameFormSchema() {
        super(LDAPSchema.schemaTypeNames[3]);
        this.obsolete = false;
    }

    public LDAPNameFormSchema(String[] stringArray, String string, String string2, boolean bl, String string3, String[] stringArray2, String[] stringArray3) {
        super(LDAPSchema.schemaTypeNames[3]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.obsolete = bl;
        this.objectClass = string3;
        this.required = (String[])stringArray2.clone();
        this.optional = (String[])stringArray3.clone();
        super.setValue(this.formatString());
    }

    public LDAPNameFormSchema(String string) {
        super(LDAPSchema.schemaTypeNames[3]);
        this.obsolete = false;
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = (String[])schemaParser.getNames().clone();
            }
            if (schemaParser.getID() != null) {
                this.oid = new String(schemaParser.getID());
            }
            if (schemaParser.getDescription() != null) {
                this.description = new String(schemaParser.getDescription());
            }
            if (schemaParser.getRequired() != null) {
                this.required = (String[])schemaParser.getRequired().clone();
            }
            if (schemaParser.getOptional() != null) {
                this.optional = (String[])schemaParser.getOptional().clone();
            }
            if (schemaParser.getObjectClass() != null) {
                this.objectClass = schemaParser.getObjectClass();
            }
            this.obsolete = schemaParser.getObsolete();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public String[] getRequiredNamingAttributes() {
        return this.required;
    }

    public String[] getOptionalNamingAttributes() {
        return this.optional;
    }

    protected String formatString() {
        Enumeration enumeration;
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((string = this.getObjectClass()) != null) {
            stringBuffer.append(" OC ");
            stringBuffer.append("'" + string + "'");
        }
        if ((stringArray = this.getRequiredNamingAttributes()) != null) {
            stringBuffer.append(" MUST ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getOptionalNamingAttributes()) != null) {
            stringBuffer.append(" MAY ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray2 = this.getQualifier(string2);
                if (stringArray2 == null) continue;
                if (stringArray2.length > 1) {
                    stringBuffer.append("( ");
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray2[i] + "'");
                }
                if (stringArray2.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPNameFormSchema lDAPNameFormSchema = (LDAPNameFormSchema)LDAPNameFormSchema.readDSML(bufferedInputStream);
        this.oid = lDAPNameFormSchema.getID();
        this.names = lDAPNameFormSchema.getNames();
        this.description = lDAPNameFormSchema.getDescription();
        this.obsolete = lDAPNameFormSchema.isObsolete();
        Enumeration enumeration = lDAPNameFormSchema.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = lDAPNameFormSchema.getQualifier(string);
            this.setQualifier(string, stringArray);
        }
        super.setValue(this.formatString());
        this.objectClass = lDAPNameFormSchema.getObjectClass();
        this.required = lDAPNameFormSchema.getRequiredNamingAttributes();
        this.optional = lDAPNameFormSchema.getOptionalNamingAttributes();
        lDAPNameFormSchema = null;
    }

    protected void writeValue(Writer writer) throws IOException {
        String string = this.formatString();
        writer.write(ValueXMLhandler.newLine(2));
        writer.write("<value>");
        writer.write(string);
        writer.write("</value>");
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String string = this.formatString();
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<value>");
        stringBuffer.append(string);
        stringBuffer.append("</value>");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPNameFormSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPNameFormSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPNameFormSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPNameFormSchema)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPNameFormSchema lDAPNameFormSchema = new LDAPNameFormSchema(this.attrName);
                byte[] byArray = (byte[])iterator.next();
                StringBuffer stringBuffer = new StringBuffer(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                try {
                    SchemaParser schemaParser = new SchemaParser(stringBuffer.toString());
                    if (schemaParser.getNames() != null) {
                        lDAPNameFormSchema.names = (String[])schemaParser.getNames().clone();
                    }
                    if (schemaParser.getID() != null) {
                        lDAPNameFormSchema.oid = new String(schemaParser.getID());
                    }
                    if (schemaParser.getDescription() != null) {
                        lDAPNameFormSchema.description = new String(schemaParser.getDescription());
                    }
                    if (schemaParser.getRequired() != null) {
                        LDAPNameFormSchema.access$002(lDAPNameFormSchema, (String[])schemaParser.getRequired().clone());
                    }
                    if (schemaParser.getOptional() != null) {
                        LDAPNameFormSchema.access$102(lDAPNameFormSchema, (String[])schemaParser.getOptional().clone());
                    }
                    if (schemaParser.getObjectClass() != null) {
                        lDAPNameFormSchema.objectClass = schemaParser.getObjectClass();
                    }
                    lDAPNameFormSchema.obsolete = schemaParser.getObsolete();
                    Enumeration enumeration = schemaParser.getQualifiers();
                    while (enumeration.hasMoreElements()) {
                        AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                        lDAPNameFormSchema.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
                    }
                    lDAPNameFormSchema.setValue(lDAPNameFormSchema.formatString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
                this.setObject(lDAPNameFormSchema);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    static /* synthetic */ String[] access$002(LDAPNameFormSchema lDAPNameFormSchema, String[] stringArray) {
        lDAPNameFormSchema.required = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$102(LDAPNameFormSchema lDAPNameFormSchema, String[] stringArray) {
        lDAPNameFormSchema.optional = stringArray;
        return stringArray;
    }
}

