/**
 * 
 */
package org.eclipse.smila.solr.admin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.ArrayUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.solr.server.SolrServers;

/**
 * @author pwissel
 * 
 */
public class EmbeddedSolrAdministration extends AbstractSolrAdministration {

  private final CoreAdminHandler _adminHandler;

  public EmbeddedSolrAdministration(SolrServers servers, CoreContainer coreContainer) {
    super(servers);
    _adminHandler = new CoreAdminHandler(coreContainer);
  }

  /**
   * @see org.eclipse.smila.solr.admin.AbstractSolrAdministration#handleRequest(java.util.Map)
   */
  @SuppressWarnings("unchecked")
  @Override
  NamedList<Object> handleRequest(Map<String, String[]> parameter) throws SolrAdministrationException {
    try {
      final String[] coreName = parameter.get(CORE);
      if (ArrayUtils.isEmpty(coreName)) {
        throw new MissingParameterException(
          "EmbeddedSolrAdministration supports status only with a core specified.");
      }
      final SolrCore core = _adminHandler.getCoreContainer().getCore(coreName[0]);
      if (core == null) {
        final String msg =
          MessageFormat.format("There is no core with name '{0}' registred in core container.", coreName[0]);
        throw new IllegalArgumentException(msg);
      }
      SolrQueryRequest req = new LocalSolrQueryRequest(core, parameter);
      SolrQueryResponse rsp = new SolrQueryResponse();
      _adminHandler.handleRequest(req, rsp);
      return rsp.getValues();
    } catch (Exception exception) {
      final String debugParameter = convertMapToString(parameter);
      throw new SolrAdministrationException("Error while handle request on embedded server with following params: "
        + debugParameter, exception);
    }
  }

  @Override
  public List<String> getCoreNames() throws Exception {
    return new ArrayList<String>(_adminHandler.getCoreContainer().getCoreNames());
  }

  @Override
  public List<String> readFieldNames(String coreName) throws Exception {
    SolrCore core = _adminHandler.getCoreContainer().getCore(coreName);
    if (core == null) {
      throw new SolrServerException("No configuration found in solr.home '"
        + _adminHandler.getCoreContainer().getSolrHome() + "' for core with name: " + coreName);
    }
    return new ArrayList<String>(core.getSchema().getFields().keySet());
  }

}
