/**
 * 
 */
package org.eclipse.smila.solr.admin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.client.solrj.response.LukeResponse.FieldInfo;
import org.apache.solr.common.util.NamedList;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.smila.solr.server.SolrServers;
import org.eclipse.smila.solr.util.SolrProperties;

/**
 * @author pwissel
 * 
 */
public class RemoteSolrAdministration extends AbstractSolrAdministration {

  private final HttpClient _httpClient = new HttpClient();

  private final SolrProperties _properties;

  public RemoteSolrAdministration(SolrServers servers, SolrProperties properties) {
    super(servers);
    _properties = properties;
  }

  /**
   * @throws SolrAdministrationException
   * @throws SolrServerException
   * @see org.eclipse.smila.solr.admin.AbstractSolrAdministration#handleRequest(java.util.Map)
   */
  @Override
  NamedList<Object> handleRequest(Map<String, String[]> parameter) throws SolrAdministrationException {
    try {
      String uri = _properties.getServerUrl();
      uri = uri + "/admin/cores";
      final PostMethod method = new PostMethod(uri);
      for (Entry<String, String[]> entry : parameter.entrySet()) {
        method.addParameter(entry.getKey(), entry.getValue()[0]);
      }
      final int status = _httpClient.executeMethod(method);
      if (status != 200) {
        // final String msg = MessageFormat.format("Solr remote server respond status was {0}.", status);
        final String body = method.getResponseBodyAsString();
        throw new HttpException(status, body);
      }
      final InputStream response = method.getResponseBodyAsStream();
      final ResponseParser parser = new XMLResponseParser();
      return parser.processResponse(response, "UTF-8");

    } catch (Exception exception) {
      final String debugParameter = convertMapToString(parameter);
      throw new SolrAdministrationException("Error while handle request on remote server with following params: "
        + debugParameter, exception);
    }
  }

  @Override
  public List<String> getCoreNames() throws Exception {
    final List<String> coreNames = new ArrayList<String>();
    final SolrServer adminServer = _servers.getAdminServer();
    final CoreAdminResponse status = CoreAdminRequest.getStatus(null, adminServer);
    final NamedList<Object> response = status.getResponse();
    if (response != null) {
      @SuppressWarnings("unchecked")
      final NamedList<Object> cores = (NamedList<Object>) response.get("status");
      if (cores != null) {
        for (Map.Entry<String, Object> entry : cores) {
          coreNames.add(entry.getKey());
        }
      }
    }
    return coreNames;
  }

  @Override
  protected List<String> readFieldNames(String coreName) throws SolrServerException, IOException {
    final SolrServer server = _servers.getSolrServer(coreName);
    final LukeRequest request = new LukeRequest();
    request.setShowSchema(true);
    request.setNumTerms(0);
    final LukeResponse response = request.process(server);
    final Map<String, FieldInfo> fields = response.getFieldInfo();
    return new ArrayList<String>(fields.keySet());
  }

}
