package org.eclipse.smila.utils.string;

import static java.lang.String.format;

import org.eclipse.core.runtime.Assert;

/**
 * Utility Class bundling common/useful methods for different string types (StringBuider, String, Charsequence, ...).
 * Might get split up into several classes when becoming too big.
 * 
 * @author tmenzel
 */
public final class StringTypesUtils {

  /**
   * 
   */
  private StringTypesUtils() {
  }

  /**
   * Add or subtract the len to the current length.
   * 
   * @param sb
   *          the sb
   * @param len
   *          the length postive values will increase the buffer, negative will decrease. Latter case will not cause an
   *          exception if by this the length will be < 0 but will set it to 0.
   * @return the string builder
   */
  public static StringBuilder setLengthRelative(final StringBuilder sb, final int len) {
    final int newLength = sb.length() + len;
    sb.setLength(Math.max(0, newLength));
    return sb;
  }

  /**
   * returns the {@link CharSequence} from the right but at most the whole buffer no matter how large len is.
   * 
   * @param sb
   *          the sb
   * @param len
   *          the len
   * @return the char sequence
   */
  public static CharSequence right(final StringBuilder sb, final int len) {

    final int offset = Math.max(0, sb.length() - len);

    return sb.subSequence(offset, sb.length());
  }

  /**
   * @param mainQuery
   * @return
   */
  public static char lastChar(StringBuilder sb) {
    return sb.charAt(sb.length());

  }

  /**
   * Used to replace the end of the current buffer, starting at reverseOffsetFromEnd.
   * 
   * @param sb
   *          the sb
   * @param reverseOffsetFromEnd
   *          will be subtracted from length of sb, negative numbers will result in \0 being inserted. Must not be >1
   *          sb.length
   * @param string
   *          the string
   */
  public static void replaceEnd(StringBuilder sb, int reverseOffsetFromEnd, CharSequence string) {

    final int start = sb.length() - reverseOffsetFromEnd;
    sb.setLength(start);

    sb.append(string);
  }

  /**
   * @param valueDescription
   * @param literalFilter
   */
  public static void assertWhitespaceFree(final CharSequence value, String valueDescription) {
    assertWhitespaceFree(value, "illegal whitespace detected in %s: %s", valueDescription, value);
  }

  /**
   * Assert that given string is free of whitespaces as determined by {@link Character#isWhitespace(char)}.
   * 
   * @param value
   *          the value
   * @param formatString
   *          the format string
   * @param formatObjects
   *          the format objects
   */
  public static void assertWhitespaceFree(final CharSequence value, String formatString, Object... formatObjects) {
    boolean found = false;
    for (int i = 0; i < value.length(); i++) {
      if (Character.isWhitespace(value.charAt(i))) {
        found = true;
        break;
      }
    }

    Assert.isTrue(!found, format(formatString, formatObjects));
  }

}
