/***********************************************************************************************************************
 * Copyright (c) 2008,2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 **********************************************************************************************************************/
package org.eclipse.smila.datamodel;

import java.io.InputStream;
import java.io.Serializable;

/**
 * Placeholder for an attachment where the content is stored in some storage service instead of in-memory. 
 * All methods of this class that access the attachment content just throw an {@link AttachmentException}.
 * 
 * <p>TODO: Add subclasses that are able to deliver the attachment content from the respective storage.
 */
public class StoredAttachment implements Attachment, Serializable {
  /** result of {@link #size()} if size is not known. */
  public static final long SIZE_UNKNOWN = -1;

  /** serializable. */
  private static final long serialVersionUID = 1L;

  /** name of attachment. */
  private final String _name;

  /** size of attachment. */
  private final long _size;

  /** create instance with unknown size. */
  public StoredAttachment(final String name) {
    this(name, SIZE_UNKNOWN);
  }

  /** create instance. */
  public StoredAttachment(final String name, final long size) {
    if (name == null) {
      throw new IllegalArgumentException("attachment name must not be null");
    }
    _name = name;
    _size = size;
  }

  @Override
  public String getName() {
    return _name;
  }

  @Override
  public long size() {
    return _size;
  }

  @Override
  public byte[] getAsBytes() {
    throw new AttachmentException("Content is stored in a persistence service.");
  }

  @Override
  public byte[] getAsBytes(final int length) {
    throw new AttachmentException("Content is stored in a persistence service.");
  }

  @Override
  public InputStream getAsStream() {
    throw new AttachmentException("Content is stored in a persistence service.");
  }

  @Override
  public void dispose() {
    // nothing to do
  }

  @Override
  public String toString() {
    return "StoredAttachment '" + _name + "', size " + size();
  }
}
