/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing;

/**
 * Class containing general constants for importing.
 * 
 * @author stuc07
 * 
 */
public final class ImportingConstants {

  /**
   * Name of the attribute that contains the delta hash.
   */
  public static final String ATTRIBUTE_DELTA_HASH = "_deltaHash";

  /**
   * Attribute set to <code>true</code> by the deltaCheck worker to mark records that are not new but have been changed.
   */
  public static final String ATTRIBUTE_UPDATE = "_update";

  /**
   * Attribute set to <code>true</code> by crawlers to denote that the record is a compound object (e.g. a ZIP archive)
   * that must be extracted.
   */
  public static final String ATTRIBUTE_COMPOUNDFLAG = "_isCompound";

  /**
   * Attribute set to the record ID of the toplevel compound an element was extracted from.
   */
  public static final String ATTRIBUTE_COMPOUNDID = "_compoundRecordId";

  /**
   * For objects extracted from a compound: Attribute containing a sequence of compound names (URLs, filenames, names in
   * compounds) to follow to get the actual data object.
   */
  public static final String ATTRIBUTE_COMPOUNDPATH = "_compoundPath";

  /**
   * Name of the task parameter that contains the data source.
   */
  public static final String TASK_PARAM_DATA_SOURCE = "dataSource";

  /**
   * Name of the task parameter that contains the mapping for property names.
   */
  public static final String TASK_PARAM_MAPPING = "mapping";

  /** Name of the task parameter that contains the filters. */
  public static final String TASK_PARAM_FILTERS = "filters";

  /**
   * Private Constructor to avoid instance creation.
   */
  private ImportingConstants() {
  }
}
