package org.eclipse.smila.importing.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.taskworker.TaskLog;

/** interface and some standard implementors for collecting messages. */
public interface MessageCollector {
  /** handle a message. */
  void add(String message);

  /** write messages as warnings to task log. */
  class TaskLogWarn implements MessageCollector {
    private final TaskLog _taskLog;

    public TaskLogWarn(final TaskLog taskLog) {
      _taskLog = taskLog;
    }

    @Override
    public void add(final String message) {
      _taskLog.warn(message);
    }
  }

  /** write messages as warnings to log file using the given class. */
  class LogWarn implements MessageCollector {
    private final Log _log;

    public LogWarn(final Class<?> clazz) {
      _log = LogFactory.getLog(clazz);
    }

    @Override
    public void add(final String message) {
      _log.warn(message);
    }
  }

  /** throw away messages. */
  class Ignore implements MessageCollector {
    @Override
    public void add(final String message) {
      ; // throw away
    }
  }
}
