/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.common.definitions.ParameterDefinition;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.processing.PipeletTrackerListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.ComponentContext;

public class PipeletTrackerImpl
implements SynchronousBundleListener,
PipeletTracker {
    private static final String DIRECTORY_SMILA_PIPELET_DESCRIPTIONS = "SMILA-INF";
    private static final String SUFFIX_SMILA_PIPELET_DESCRIPTIONS = "*.json";
    private final Log _log = LogFactory.getLog(PipeletTrackerImpl.class);
    private final Map<String, Map<String, Class<? extends Pipelet>>> _knownPipelets = new HashMap<String, Map<String, Class<? extends Pipelet>>>();
    private final Map<String, Map<String, AnyMap>> _knownPipeletDescriptions = new HashMap<String, Map<String, AnyMap>>();
    private final Collection<PipeletTrackerListener> _listeners = new ArrayList<PipeletTrackerListener>();
    private final IpcAnyReader _anyReader = new IpcAnyReader();

    @Override
    public Map<String, Class<? extends Pipelet>> getRegisteredPipelets() {
        TreeMap<String, Class<? extends Pipelet>> registeredPipelets = new TreeMap<String, Class<? extends Pipelet>>();
        for (Map<String, Class<? extends Pipelet>> bundlePipelets : this._knownPipelets.values()) {
            registeredPipelets.putAll(bundlePipelets);
        }
        return registeredPipelets;
    }

    @Override
    public Map<String, AnyMap> getRegisteredPipeletDescriptions() {
        TreeMap<String, AnyMap> registeredPipeletDescriptions = new TreeMap<String, AnyMap>();
        for (Map<String, AnyMap> bundlePipelets : this._knownPipeletDescriptions.values()) {
            registeredPipeletDescriptions.putAll(bundlePipelets);
        }
        return registeredPipeletDescriptions;
    }

    @Override
    public void addListener(PipeletTrackerListener listener) {
        this._listeners.add(listener);
        for (Map<String, Class<? extends Pipelet>> pipeletClassNames : this._knownPipelets.values()) {
            listener.pipeletsAdded(pipeletClassNames);
        }
    }

    @Override
    public void removeListener(PipeletTrackerListener listener) {
        this._listeners.remove(listener);
    }

    protected void activate(ComponentContext componentContext) {
        Bundle[] bundles;
        BundleContext bundleContext = componentContext.getBundleContext();
        bundleContext.addBundleListener((BundleListener)this);
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 0x2C) > 0) {
                this.bundleAdded(bundle);
            }
            ++n2;
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        BundleContext bundleContext = componentContext.getBundleContext();
        bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 32: {
                this.bundleAdded(event.getBundle());
                break;
            }
            case 128: {
                this.bundleAdded(event.getBundle());
                break;
            }
            case 256: {
                this.bundleRemoved(event.getBundle());
            }
        }
    }

    private void bundleAdded(Bundle bundle) {
        String bundleName = bundle.getSymbolicName();
        if (this._knownPipelets.containsKey(bundleName)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Pipelets from bundle " + bundleName + " have been loaded already, skipping."));
            }
        } else {
            HashMap<String, Class<? extends Pipelet>> pipeletClasses = new HashMap<String, Class<? extends Pipelet>>();
            HashMap<String, AnyMap> pipeletDescriptionMap = new HashMap<String, AnyMap>();
            Enumeration pipeletDescriptionUrls = bundle.findEntries(DIRECTORY_SMILA_PIPELET_DESCRIPTIONS, SUFFIX_SMILA_PIPELET_DESCRIPTIONS, true);
            if (pipeletDescriptionUrls != null) {
                while (pipeletDescriptionUrls.hasMoreElements()) {
                    URL pipeletDescriptionUrl = (URL)pipeletDescriptionUrls.nextElement();
                    String fileName = pipeletDescriptionUrl.getFile();
                    try {
                        AnyMap pipeletDescriptionAny = this.loadPipeletDescription(pipeletDescriptionUrl);
                        String pipeletClassName = pipeletDescriptionAny.getStringValue("class");
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("Found pipelet desciption '" + fileName + "' (class '" + pipeletClassName + "') in bundle '" + bundleName + "'."));
                        }
                        this.loadPipeletClass(pipeletClasses, pipeletClassName, bundle);
                        this.checkPipeletDescription(pipeletClasses, pipeletDescriptionAny, pipeletClassName);
                        pipeletDescriptionMap.put(pipeletClassName, pipeletDescriptionAny);
                    }
                    catch (IOException e) {
                        this._log.error((Object)("Cannot load pipelet description '" + fileName + "' from bundle '" + bundleName + "'."), (Throwable)e);
                    }
                }
                if (!pipeletDescriptionMap.isEmpty()) {
                    this._knownPipeletDescriptions.put(bundleName, pipeletDescriptionMap);
                }
                if (!pipeletClasses.isEmpty()) {
                    this._knownPipelets.put(bundleName, pipeletClasses);
                    for (PipeletTrackerListener listener : this._listeners) {
                        listener.pipeletsAdded(pipeletClasses);
                    }
                }
            }
        }
    }

    protected void checkPipeletDescription(Map<String, Class<? extends Pipelet>> pipeletClasses, AnyMap pipeletDescriptionAny, String pipeletClassName) {
        Any parameters;
        if (!pipeletClasses.containsKey(pipeletClassName)) {
            pipeletDescriptionAny.add("errors", (Any)DataFactory.DEFAULT.createStringValue("Pipelet class could not be loaded."));
            this._log.error((Object)("Pipelet '" + pipeletClassName + "' cannot be found."));
        }
        if ((parameters = (Any)pipeletDescriptionAny.get((Object)"parameters")) != null && !parameters.isEmpty()) {
            if (parameters.getValueType() != Any.ValueType.SEQ) {
                pipeletDescriptionAny.add("errors", (Any)DataFactory.DEFAULT.createStringValue("Parameters section is not of Type " + Any.ValueType.SEQ.name()));
                this._log.warn((Object)("Parameters section of pipelet '" + pipeletClassName + "' is no sequence."));
            } else {
                try {
                    ParameterDefinition.parseParameters((AnySeq)((AnySeq)parameters));
                }
                catch (InvalidDefinitionException e) {
                    pipeletDescriptionAny.add("errors", (Any)DataFactory.DEFAULT.createStringValue("Parameters section is invalid. " + e.getMessage()));
                    this._log.warn((Object)("Parameters section of pipelet '" + pipeletClassName + "' is invalid."), (Throwable)e);
                }
            }
        }
    }

    private AnyMap loadPipeletDescription(URL pipeletDescriptionUrl) throws IOException {
        InputStream pipeletDescriptionStream = pipeletDescriptionUrl.openStream();
        try {
            AnyMap anyMap = (AnyMap)this._anyReader.readJsonStream(pipeletDescriptionStream);
            return anyMap;
        }
        finally {
            IOUtils.closeQuietly((InputStream)pipeletDescriptionStream);
        }
    }

    private void loadPipeletClass(Map<String, Class<? extends Pipelet>> pipeletClasses, String pipeletClassName, Bundle bundle) {
        String trimmedClassName = pipeletClassName.trim();
        if (trimmedClassName.length() > 0) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Found pipelet class name = " + trimmedClassName));
            }
            try {
                Class pipeletClass = bundle.loadClass(trimmedClassName);
                pipeletClasses.put(trimmedClassName, pipeletClass);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Pipelet class " + trimmedClassName + " loaded."));
                }
            }
            catch (ClassNotFoundException ex) {
                this._log.error((Object)("Pipelet class " + trimmedClassName + " could not be loaded from bundle " + bundle.getSymbolicName()), (Throwable)ex);
            }
        }
    }

    private void bundleRemoved(Bundle bundle) {
        String bundleName = bundle.getSymbolicName();
        if (this._knownPipelets.containsKey(bundleName)) {
            Map<String, Class<? extends Pipelet>> pipeletClassNames = this._knownPipelets.remove(bundleName);
            for (PipeletTrackerListener listener : this._listeners) {
                listener.pipeletsRemoved(pipeletClassNames);
            }
        }
    }
}

