/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.worker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.DeltaImportStrategy;
import org.eclipse.smila.importing.DeltaService;
import org.eclipse.smila.importing.worker.WorkerUsingDeltaService;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.taskgenerator.DefaultTaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.taskmanager.Task;

public class UpdatePusherTaskGenerator
extends DefaultTaskGenerator {
    private DeltaService _deltaService;
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public List<Task> createCompletionTasks(Map<String, Bucket> inputBuckets, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) throws TaskGeneratorException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        DeltaImportStrategy deltaUsage = WorkerUsingDeltaService.getDeltaImportStrategy(parameters);
        if (deltaUsage.isDeltaDeleteEnabled()) {
            String sourceId = parameters.getStringValue("dataSource");
            try {
                Collection<String> shards = this._deltaService.getShardPrefixes(sourceId);
                for (String shard : shards) {
                    Task task = this.createCompletionTask(parameters, workerName);
                    task.getParameters().put("deleteRecordsShard", shard);
                    tasks.add(task);
                }
            }
            catch (DeltaException ex) {
                throw new TaskGeneratorException("Failed to create completion tasks", (Throwable)((Object)ex));
            }
        } else {
            this._log.info((Object)("Delta-Delete is disabled for usage = " + (Object)((Object)deltaUsage) + ", no tasks created."));
        }
        return tasks;
    }

    public void setDeltaService(DeltaService deltaService) {
        this._deltaService = deltaService;
    }

    public void unsetDeltaService(DeltaService deltaService) {
        if (this._deltaService == deltaService) {
            this._deltaService = null;
        }
    }
}

