/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.worker;

import java.util.Collection;
import java.util.Locale;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.DeltaImportStrategy;
import org.eclipse.smila.importing.DeltaService;
import org.eclipse.smila.importing.State;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;

public abstract class WorkerUsingDeltaService
implements Worker {
    private DeltaService _deltaService;

    protected String getJobRunId(TaskContext taskContext) {
        String jobRunId = (String)taskContext.getTask().getProperties().get("jobRunId");
        if (jobRunId == null) {
            throw new IllegalArgumentException("Missing property 'jobRunId' in task: " + taskContext.getTask());
        }
        return jobRunId;
    }

    protected String getRequiredParameter(TaskContext taskContext, String parameter) {
        String targetJobName = taskContext.getTaskParameters().getStringValue(parameter);
        if (targetJobName == null) {
            throw new IllegalArgumentException("Missing parameter '" + parameter + "' in task: " + taskContext.getTask());
        }
        return targetJobName;
    }

    protected DeltaImportStrategy getDeltaImportStrategy(TaskContext taskContext) {
        return WorkerUsingDeltaService.getDeltaImportStrategy(taskContext.getTaskParameters());
    }

    protected static DeltaImportStrategy getDeltaImportStrategy(AnyMap taskParameters) {
        DeltaImportStrategy usage = DeltaImportStrategy.FULL;
        String paramValue = taskParameters.getStringValue("deltaImportStrategy");
        if (paramValue != null) {
            try {
                usage = DeltaImportStrategy.valueOf(paramValue.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {}
        }
        return usage;
    }

    protected String getCompoundId(Record record) {
        return record.getMetadata().getStringValue("_compoundRecordId");
    }

    protected boolean isCompound(Record record) {
        if (record.getMetadata().containsKey((Object)"_isCompound")) {
            return record.getMetadata().getBooleanValue("_isCompound");
        }
        return false;
    }

    public State checkDeltaStateTimed(String jobRunId, Record record, String deltaHash, TaskContext taskContext) throws DeltaException {
        long startTime = taskContext.getTimestamp();
        try {
            String compoundId = this.getCompoundId(record);
            State deltaStatus = this._deltaService.checkState(record.getSource(), record.getId(), compoundId, jobRunId, deltaHash);
            if (deltaStatus == State.CHANGED) {
                record.getMetadata().put("_update", Boolean.valueOf(true));
            }
            State state = deltaStatus;
            return state;
        }
        finally {
            taskContext.measureTime("checkDeltaState", startTime);
        }
    }

    public void markCompoundElementsVisitedTimed(String jobRunId, Record record, TaskContext taskContext) throws DeltaException {
        long startTime = taskContext.getTimestamp();
        try {
            this._deltaService.markCompoundElementsVisited(record.getSource(), record.getId(), jobRunId);
        }
        finally {
            taskContext.measureTime("markCompoundElementsVisited", startTime);
        }
    }

    public void markAsUpdatedTimed(String jobRunId, Record record, String deltaHash, TaskContext taskContext) throws DeltaException {
        long startTime = taskContext.getTimestamp();
        try {
            String compoundId = this.getCompoundId(record);
            this._deltaService.markAsUpdated(record.getSource(), record.getId(), compoundId, jobRunId, deltaHash);
        }
        finally {
            taskContext.measureTime("markAsUpdated", startTime);
        }
    }

    public Collection<DeltaService.EntryId> getUnvisitedEntriesTimed(String jobRunId, String sourceAndShardPrefix, TaskContext taskContext) throws DeltaException {
        long startTime = taskContext.getTimestamp();
        try {
            Collection<DeltaService.EntryId> collection = this._deltaService.getUnvisitedEntries(sourceAndShardPrefix, jobRunId);
            return collection;
        }
        finally {
            taskContext.measureTime("getUnvisitedRecords", startTime);
        }
    }

    public void deleteDeltaEntryTimed(String sourceId, DeltaService.EntryId entryId, TaskContext taskContext) throws DeltaException {
        long startTime = taskContext.getTimestamp();
        try {
            this._deltaService.deleteEntry(sourceId, entryId);
        }
        finally {
            taskContext.measureTime("deleteDeltaEntry", startTime);
        }
    }

    public void setDeltaService(DeltaService service) {
        this._deltaService = service;
    }

    public void unsetDeltaService(DeltaService service) {
        if (this._deltaService == service) {
            this._deltaService = null;
        }
    }
}

