/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.search.api.SearchService;
import org.eclipse.smila.search.servlet.activator.Activator;

public class RecordSearchServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PARAM_FILE = "file";
    private static final String DEFAULT_SEARCH_PIPELINE = "SearchPipeline";
    protected final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            SearchService service = Activator.getSearchService();
            if (service == null) {
                throw new IllegalStateException("SearchService must not be null.");
            }
            String parameter = req.getParameter(PARAM_FILE);
            Object inputStream = parameter == null ? req.getInputStream() : FileUtils.openInputStream((File)new File(parameter).getAbsoluteFile());
            Record searchRecord = XmlSerializationUtils.deserializeNoAttachments((InputStream)inputStream);
            String workflow = searchRecord.getMetadata().getStringValue("_workflow");
            if (StringUtils.isBlank((String)workflow)) {
                workflow = DEFAULT_SEARCH_PIPELINE;
            }
            String resultXml = service.searchAsXmlString(workflow, searchRecord);
            resp.setContentType("text/xml");
            ServletOutputStream out = resp.getOutputStream();
            out.write(resultXml.getBytes("UTF-8"));
        }
        catch (IllegalStateException exception) {
            this.handleError(409, exception, resp);
        }
        catch (Exception exception) {
            this.handleError(500, exception, resp);
        }
    }

    private void handleError(int errorCode, Throwable exception, HttpServletResponse resp) throws IOException {
        String msg = ExceptionUtils.getFullStackTrace((Throwable)exception);
        this._log.error((Object)msg);
        resp.sendError(errorCode, msg);
    }
}

