/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.ontology.pipelets.ASesameRecordPipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class CreateRelationPipelet
extends ASesameRecordPipelet {
    public static final String PARAM_SUBJECTATTRIBUTE = "subjectAttribute";
    public static final String PARAM_OBJECTATTRIBUTE = "objectAttribute";
    public static final String PARAM_OBJECT_IS_RESOURCE = "objectAttributeIsResource";
    public static final String PARAM_PREDICATEURI = "predicateUri";
    private final Log _log = LogFactory.getLog(this.getClass());

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null && recordIds.length > 0) {
            try {
                ParameterAccessor parameters = this.getParameters(blackboard);
                String[] stringArray = recordIds;
                int n = recordIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    parameters.setCurrentRecord(id);
                    try (RepositoryConnection connection = this.getRepositoryConnection(parameters);){
                        try {
                            String subjectAttribute = parameters.getRequiredParameter(PARAM_SUBJECTATTRIBUTE);
                            String objectAttribute = parameters.getRequiredParameter(PARAM_OBJECTATTRIBUTE);
                            String predicateUriString = parameters.getRequiredParameter(PARAM_PREDICATEURI);
                            boolean objectAttributeIsResource = parameters.getBooleanParameter(PARAM_OBJECT_IS_RESOURCE, Boolean.valueOf(true));
                            URI predicate = this.createUri(connection, predicateUriString);
                            AnyMap metadata = blackboard.getMetadata(id);
                            Any subjectAny = (Any)metadata.get((Object)subjectAttribute);
                            if (subjectAny.size() > 0) {
                                AnySeq objects;
                                AnySeq subjects;
                                if (((Any)metadata.get((Object)subjectAttribute)).isSeq()) {
                                    subjects = metadata.getSeq(subjectAttribute);
                                } else {
                                    subjects = metadata.getFactory().createAnySeq();
                                    subjects.add((Object)((Any)metadata.get((Object)subjectAttribute)));
                                }
                                if (((Any)metadata.get((Object)subjectAttribute)).isSeq()) {
                                    objects = metadata.getSeq(objectAttribute);
                                } else {
                                    objects = metadata.getFactory().createAnySeq();
                                    objects.add((Object)((Any)metadata.get((Object)objectAttribute)));
                                }
                                int i = 0;
                                while (i < subjects.size()) {
                                    URI subject = this.createUri(connection, subjects.getStringValue(i));
                                    this.createRelations(connection, subject, predicate, objects, objectAttributeIsResource);
                                    ++i;
                                }
                            }
                            connection.commit();
                        }
                        catch (BlackboardAccessException ex) {
                            throw new ProcessingException("error accessing blackboard", (Throwable)ex);
                        }
                    }
                    ++n2;
                }
            }
            catch (RepositoryException ex) {
                throw new ProcessingException("could not get connection to sesame repository", (Throwable)ex);
            }
        }
        return recordIds;
    }

    private void createRelations(RepositoryConnection connection, URI subject, URI predicate, AnySeq objects, boolean objectAttributeIsResource) throws RepositoryException {
        for (Any objectAny : objects) {
            if (objectAny.isString()) {
                org.eclipse.smila.datamodel.Value anyValue = (org.eclipse.smila.datamodel.Value)objectAny;
                Object object = objectAttributeIsResource ? this._valueHelper.createUri(connection, anyValue.asString()) : this._valueHelper.createLiteral(connection, anyValue, null);
                connection.add((Resource)subject, predicate, (Value)object, new Resource[0]);
                continue;
            }
            if (!this._log.isWarnEnabled()) continue;
            this._log.warn((Object)("Object '" + objectAny + "' is no string. Cannot create a relation to a not string value."));
        }
    }
}

