/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.common.mimetype.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class MimeTypeMapper {
    private static final String DEFAULT_EXTENSION_FILE = "mime.types";
    private HashMap<String, String> _mimeTypeExtensions = new HashMap();
    private HashMap<String, String> _extensionMimeTypes = new HashMap();

    public MimeTypeMapper() throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(MimeTypeMapper.class.getResourceAsStream(DEFAULT_EXTENSION_FILE), "ISO-8859-1")));
    }

    public MimeTypeMapper(InputStream input) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(input, "ISO-8859-1")));
    }

    public MimeTypeMapper(InputStream input, String encoding) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(input, encoding)));
    }

    public String getContentType(String extension) {
        if (extension == null) {
            throw new NullPointerException("parameter extension is null");
        }
        return this._mimeTypeExtensions.get(extension.toLowerCase(Locale.ENGLISH));
    }

    public String getExtension(String contentType) {
        if (contentType == null) {
            throw new NullPointerException("parameter contentType is null");
        }
        return this._extensionMimeTypes.get(contentType);
    }

    private synchronized void parse(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        HashMap mimeTypes = (HashMap)this._extensionMimeTypes.clone();
        HashMap extensions = (HashMap)this._mimeTypeExtensions.clone();
        int count = 0;
        String currentMimetype = null;
        while ((line = reader.readLine()) != null) {
            int stringLength = (currentMimetype = currentMimetype != null ? String.valueOf(currentMimetype) + line : line).length();
            if (stringLength == 0) {
                currentMimetype = null;
                continue;
            }
            if (currentMimetype.charAt(stringLength - 1) != '\\') {
                count += this.parseMimeTypeExtension(currentMimetype, mimeTypes, extensions);
                currentMimetype = null;
                continue;
            }
            currentMimetype = currentMimetype.substring(0, stringLength - 1);
        }
        if (currentMimetype != null) {
            count += this.parseMimeTypeExtension(currentMimetype, mimeTypes, extensions);
        }
        if (count > 0) {
            this._extensionMimeTypes = mimeTypes;
            this._mimeTypeExtensions = extensions;
        }
    }

    protected int parseMimeTypeExtension(String mimetype, Map<String, String> mimeTypes, Map<String, String> extensions) {
        if (mimetype == null) {
            throw new NullPointerException("spec");
        }
        if (mimeTypes == null) {
            throw new NullPointerException("mimeTypes");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions");
        }
        int count = 0;
        if ((mimetype = mimetype.trim()).length() > 0 && mimetype.charAt(0) != '#') {
            StringTokenizer tokens = new StringTokenizer(mimetype);
            String type = tokens.nextToken();
            while (tokens.hasMoreTokens()) {
                String ext = tokens.nextToken();
                if (ext.length() == 0) continue;
                ext = ext.toLowerCase(Locale.ENGLISH);
                extensions.put(ext, type);
                if (count++ != 0) continue;
                mimeTypes.put(type, ext);
            }
        }
        return count;
    }
}

