/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.fetcher;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpResponseInputStream
extends InputStream {
    private final String _url;
    private final HttpResponse _response;
    private InputStream _responseBody;
    private final boolean _isRedirect;

    public HttpResponseInputStream(String url, HttpResponse response, boolean isRedirect) throws IOException {
        this._response = response;
        this._url = url;
        this._isRedirect = isRedirect;
    }

    public String getUrl() {
        return this._url;
    }

    public boolean isRedirect() {
        return this._isRedirect;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public HttpEntity getResponseEntity() {
        if (this._response == null) {
            return null;
        }
        return this._response.getEntity();
    }

    @Override
    public int read() throws IOException {
        this.ensureStream();
        if (this._responseBody == null) {
            return -1;
        }
        return this._responseBody.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureStream();
        if (this._responseBody == null) {
            return -1;
        }
        return this._responseBody.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        this.ensureStream();
        if (this._responseBody == null) {
            return 0;
        }
        return this._responseBody.available();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureStream();
        if (this._responseBody == null) {
            return 0L;
        }
        return this._responseBody.skip(n);
    }

    @Override
    public void close() {
        if (this._responseBody != null) {
            IOUtils.closeQuietly((InputStream)this._responseBody);
        }
        if (this.getResponseEntity() != null) {
            try {
                EntityUtils.consume((HttpEntity)this._response.getEntity());
            }
            catch (IOException iOException) {}
        }
    }

    private void ensureStream() throws IOException {
        if (this._responseBody == null && this.getResponseEntity() != null) {
            this._responseBody = this._response.getEntity().getContent();
        }
    }
}

