/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1.xpath10.jaxp;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.WrappedResolverException;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.v1.CompilerContext;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.bpel.rtrep.v1.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;

public class JaxpVariableResolver
implements XPathVariableResolver {
    private static final Log __log = LogFactory.getLog(XPathVariableResolver.class);
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath10Expression _oxpath;

    public JaxpVariableResolver(CompilerContext compilerContext, OXPath10Expression oXPath10Expression) {
        this._cctx = compilerContext;
        this._oxpath = oXPath10Expression;
    }

    public Object resolveVariable(QName qName) {
        __log.debug((Object)("JAXP compiler: Resolving variable " + qName));
        if (("ode".equals(qName.getPrefix()) || "http://www.apache.org/ode/type/extension".equals(qName.getNamespaceURI())) && "pid".equals(qName.getLocalPart())) {
            return "";
        }
        try {
            String string = qName.getLocalPart();
            if (this._oxpath instanceof OXPath10ExpressionBPEL20 && ((OXPath10ExpressionBPEL20)this._oxpath).isJoinExpression) {
                OLink oLink = this._cctx.resolveLink(string);
                this._oxpath.links.put(string, oLink);
                return Boolean.TRUE;
            }
            int n = string.indexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            OScope.Variable variable = this._cctx.resolveVariable(string);
            this._oxpath.vars.put(string, variable);
            return this.extractValue(variable, variable.type);
        }
        catch (CompilationException compilationException) {
            throw new WrappedResolverException(compilationException);
        }
    }

    private Object extractValue(OScope.Variable variable, OVarType oVarType) {
        if (oVarType instanceof OXsdTypeVarType) {
            return this.generateFromType(((OXsdTypeVarType)oVarType).xsdType);
        }
        if (oVarType instanceof OElementVarType) {
            return this.generateFromType(((OElementVarType)oVarType).elementType);
        }
        if (oVarType instanceof OMessageVarType) {
            if (((OMessageVarType)oVarType).parts.size() == 0) {
                throw new WrappedResolverException(__msgs.errExpressionMessageNoPart(variable.name));
            }
            return this.extractValue(variable, ((OMessageVarType.Part)((OMessageVarType)oVarType).parts.values().iterator().next()).type);
        }
        return "";
    }

    private Object generateFromType(QName qName) {
        if (qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            if (qName.getLocalPart().equals("int") || qName.getLocalPart().equals("integer") || qName.getLocalPart().equals("short") || qName.getLocalPart().equals("long") || qName.getLocalPart().equals("byte") || qName.getLocalPart().equals("float") || qName.getLocalPart().equals("double") || qName.getLocalPart().equals("nonPositiveInteger") || qName.getLocalPart().equals("nonNegativeInteger") || qName.getLocalPart().equals("negativeInteger") || qName.getLocalPart().equals("unsignedLong") || qName.getLocalPart().equals("unsignedInt") || qName.getLocalPart().equals("unsignedShort") || qName.getLocalPart().equals("unsignedByte")) {
                return 0;
            }
            if (qName.getLocalPart().equals("boolean")) {
                return Boolean.TRUE;
            }
            if (qName.getLocalPart().equals("string")) {
                return "";
            }
        }
        Document document = DOMUtils.newDocument();
        document.appendChild(document.createElement("empty"));
        return document.getDocumentElement();
    }
}

