/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.crawler.file.FileCrawlerWorker;
import org.eclipse.smila.importing.crawler.file.filter.FilterConfiguration;
import org.eclipse.smila.importing.crawler.file.filter.FilterEvaluator;
import org.eclipse.smila.importing.util.CrawlingContext;
import org.eclipse.smila.taskworker.TaskContext;

public final class FileCrawlingContext
extends CrawlingContext {
    private final String _rootFolder;
    private final long _maxFilesPerBulk;
    private final long _minFilesPerBulk;
    private final long _directoriesPerBulk;
    private final FilterConfiguration _filterConfig;
    private final FilterEvaluator _filterEvaluator;

    public FileCrawlingContext(TaskContext taskContext) {
        super(taskContext, false);
        AnyMap taskParameters = taskContext.getTaskParameters();
        this._rootFolder = taskParameters.getStringValue("rootFolder");
        if (this._rootFolder == null || this._rootFolder.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter 'rootFolder' of task " + taskContext.getTask().getTaskId() + " is null or empty");
        }
        this._maxFilesPerBulk = this.getNonNegativeParameter(taskParameters, "maxFilesPerBulk", FileCrawlerWorker.MAX_FILES_PER_BULK_DEFAULT);
        if (this._maxFilesPerBulk == 0L) {
            throw new IllegalArgumentException("Task parameter maxFilesPerBulk must be greater than 0");
        }
        this._minFilesPerBulk = this.getNonNegativeParameter(taskParameters, "minFilesPerBulk", FileCrawlerWorker.MIN_FILES_PER_BULK_DEFAULT);
        if (this._maxFilesPerBulk <= this._minFilesPerBulk) {
            throw new IllegalArgumentException("Task parameter maxFilesPerBulk is less or equal to minFilesPerBulk");
        }
        this._directoriesPerBulk = this.getNonNegativeParameter(taskParameters, "directoriesPerBulk", FileCrawlerWorker.DIRS_PER_BULK_DEFAULT);
        this._filterConfig = taskParameters.get((Object)"filters") != null ? new FilterConfiguration(taskParameters.getMap("filters")) : null;
        this._filterEvaluator = new FilterEvaluator();
        this._filterEvaluator.setFilterConfiguration(this._filterConfig);
    }

    public String getRootFolder() {
        return this._rootFolder;
    }

    public FilterEvaluator getFilterEvaluator() {
        return this._filterEvaluator;
    }

    public FilterConfiguration getFilterConfig() {
        return this._filterConfig;
    }

    public long getMaxFilesPerBulk() {
        return this._maxFilesPerBulk;
    }

    public long getMinFilesPerBulk() {
        return this._minFilesPerBulk;
    }

    public long getDirectoriesPerBulk() {
        return this._directoriesPerBulk;
    }
}

