/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.jdbc.internal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.importing.crawler.jdbc.DbAccessService;
import org.eclipse.smila.importing.crawler.jdbc.SqlExecutor;
import org.eclipse.smila.importing.crawler.jdbc.internal.ResultSetToAnyConverter;
import org.eclipse.smila.importing.util.MessageCollector;
import org.eclipse.smila.jdbc.JdbcProvider;

public class JdbcDbAccessService
implements DbAccessService {
    private final Log _log = LogFactory.getLog(this.getClass());
    private JdbcProvider _jdbcProvider;

    @Override
    public Collection<Record> executeSql(String url, AnyMap dbProperties, String sql, long maxAttachmentSize, MessageCollector messages) throws SQLException, IOException {
        return this.executeSql(url, AnyUtil.anyToProperties((AnyMap)dbProperties), sql, maxAttachmentSize, messages);
    }

    @Override
    public Collection<Record> executeSql(String url, Properties dbProperties, String sql, long maxAttachmentSize, MessageCollector messages) throws SQLException, IOException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Collection<Record> result;
            con = this._jdbcProvider.getConnection(url, dbProperties);
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            Collection<Record> collection = result = ResultSetToAnyConverter.convertResultSetToAny(rs, maxAttachmentSize, messages);
            this.closeQuietly(con, stmt, rs);
            return collection;
        }
        catch (Throwable throwable) {
            this.closeQuietly(con, stmt, rs);
            throw throwable;
        }
    }

    @Override
    public SqlExecutor executePrepared(String url, AnyMap dbProperties, String sql, long maxAttachmentSize, MessageCollector messages) throws SQLException {
        return this.executePrepared(url, AnyUtil.anyToProperties((AnyMap)dbProperties), sql, maxAttachmentSize, messages);
    }

    @Override
    public SqlExecutor executePrepared(String url, Properties dbProperties, String sql, long maxAttachmentSize, MessageCollector messages) throws SQLException {
        Connection con = null;
        try {
            con = this._jdbcProvider.getConnection(url, dbProperties);
            SqlExecutor sqlExecutor = new SqlExecutor(con, sql, maxAttachmentSize, messages);
            return sqlExecutor;
        }
        catch (SQLException e) {
            this.closeQuietly(con, null, null);
            throw e;
        }
        catch (Exception e) {
            this.closeQuietly(con, null, null);
            throw new SQLException(e);
        }
    }

    private void closeQuietly(Connection con, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                this._log.warn((Object)"Error while closing ResultSet: ", (Throwable)e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                this._log.warn((Object)"Error while closing Statement: ", (Throwable)e);
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                this._log.warn((Object)"Error while closing Connection: ", (Throwable)e);
            }
        }
    }

    public void setJdbcProvider(JdbcProvider jdbcProvider) {
        this._jdbcProvider = jdbcProvider;
    }

    public void unsetJdbcProvider(JdbcProvider jdbcProvider) {
        if (this._jdbcProvider == jdbcProvider) {
            this._jdbcProvider = null;
        }
    }
}

