/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.jdbc.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.util.MessageCollector;

public class ResultSetToAnyConverter {
    public static Collection<Record> convertResultSetToAny(ResultSet resultSet, long maxAttachmentSize, MessageCollector messages) throws SQLException, IOException {
        if (resultSet == null) {
            return null;
        }
        DataFactory df = DataFactory.DEFAULT;
        ArrayList<Record> resultRecords = new ArrayList<Record>();
        while (resultSet.next()) {
            Record record = df.createRecord();
            AnyMap recordMetadata = record.getMetadata();
            ResultSetMetaData resultSetMetadata = resultSet.getMetaData();
            int i = 1;
            while (i <= resultSetMetadata.getColumnCount()) {
                String columnName = resultSetMetadata.getColumnName(i).toUpperCase(Locale.ENGLISH);
                int columnType = resultSetMetadata.getColumnType(i);
                switch (columnType) {
                    case -7: 
                    case 16: {
                        boolean booleanValue = resultSet.getBoolean(i);
                        if (resultSet.wasNull()) break;
                        recordMetadata.put(columnName, (Any)df.createBooleanValue(Boolean.valueOf(booleanValue)));
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long longValue = resultSet.getLong(i);
                        if (resultSet.wasNull()) break;
                        recordMetadata.put(columnName, (Any)df.createLongValue(Long.valueOf(longValue)));
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        double doubleValue = resultSet.getDouble(i);
                        if (resultSet.wasNull()) break;
                        recordMetadata.put(columnName, (Any)df.createDoubleValue(Double.valueOf(doubleValue)));
                        break;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigDecimalValue = resultSet.getBigDecimal(i);
                        if (resultSet.wasNull()) break;
                        if (resultSetMetadata.getScale(i) > 0) {
                            recordMetadata.put(columnName, (Any)df.createDoubleValue(Double.valueOf(bigDecimalValue.doubleValue())));
                            break;
                        }
                        recordMetadata.put(columnName, (Any)df.createLongValue(Long.valueOf(bigDecimalValue.longValue())));
                        break;
                    }
                    case 91: {
                        Date dateValue = resultSet.getDate(i);
                        if (resultSet.wasNull()) break;
                        recordMetadata.put(columnName, (Any)df.createDateValue((java.util.Date)dateValue));
                        break;
                    }
                    case 92: {
                        Time timeValue = resultSet.getTime(i);
                        if (resultSet.wasNull()) break;
                        recordMetadata.put(columnName, (Any)df.createDateTimeValue((java.util.Date)timeValue));
                        break;
                    }
                    case 93: {
                        Timestamp timeStampValue = resultSet.getTimestamp(i);
                        if (resultSet.wasNull()) break;
                        recordMetadata.put(columnName, (Any)df.createDateTimeValue((java.util.Date)timeStampValue));
                        break;
                    }
                    case -15: 
                    case -9: 
                    case -8: 
                    case 1: 
                    case 12: {
                        String stringValue = resultSet.getString(i);
                        if (resultSet.wasNull()) break;
                        recordMetadata.put(columnName, (Any)df.createStringValue(stringValue));
                        break;
                    }
                    case -3: 
                    case -2: {
                        byte[] byteValue = resultSet.getBytes(i);
                        if (resultSet.wasNull()) break;
                        if ((long)byteValue.length > maxAttachmentSize) {
                            ResultSetToAnyConverter.logWarnAttachmentTooLarge(columnName, byteValue.length, maxAttachmentSize, messages);
                            break;
                        }
                        record.setAttachment(columnName, byteValue);
                        break;
                    }
                    case -4: 
                    case 2004: {
                        Blob blob = resultSet.getBlob(i);
                        if (resultSet.wasNull()) break;
                        if (blob.length() > maxAttachmentSize) {
                            ResultSetToAnyConverter.logWarnAttachmentTooLarge(columnName, blob.length(), maxAttachmentSize, messages);
                            break;
                        }
                        InputStream binaryStream = blob.getBinaryStream();
                        record.setAttachment(columnName, IOUtils.toByteArray((InputStream)binaryStream));
                        break;
                    }
                    case -16: 
                    case -1: 
                    case 2005: 
                    case 2011: {
                        Clob clob = resultSet.getClob(i);
                        if (resultSet.wasNull()) break;
                        if (clob.length() > maxAttachmentSize) {
                            ResultSetToAnyConverter.logWarnAttachmentTooLarge(columnName, clob.length(), maxAttachmentSize, messages);
                            break;
                        }
                        Reader streamReader = clob.getCharacterStream();
                        record.setAttachment(columnName, IOUtils.toByteArray((Reader)streamReader, (String)"UTF-8"));
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        Object objectValue = resultSet.getObject(i);
                        try {
                            if (resultSet.wasNull()) break;
                            recordMetadata.put(columnName, (Any)df.autoConvertValue(objectValue));
                            break;
                        }
                        catch (InvalidValueTypeException invalidValueTypeException) {
                            record.setAttachment(columnName, resultSet.getBytes(i));
                        }
                    }
                }
                ++i;
            }
            resultRecords.add(record);
        }
        return resultRecords;
    }

    private static void logWarnAttachmentTooLarge(String columnName, long length, long maxAttachmentSize, MessageCollector messages) {
        messages.add("No attachment created from a value in column " + columnName + " because its length " + length + " exceeded the allowed length " + maxAttachmentSize);
    }
}

