/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public final class Predicate
extends QueryTreeNode
implements OptimizablePredicate,
Comparable {
    AndNode andNode;
    boolean pushable;
    JBitSet referencedSet;
    int equivalenceClass = -1;
    int indexPosition;
    protected boolean startKey;
    protected boolean stopKey;
    protected boolean isQualifier;
    private Hashtable searchClauseHT;
    private boolean scoped;

    public void init(Object andNode, Object referencedSet) {
        this.andNode = (AndNode)andNode;
        this.pushable = false;
        this.referencedSet = (JBitSet)referencedSet;
        this.scoped = false;
    }

    public JBitSet getReferencedMap() {
        return this.referencedSet;
    }

    public boolean hasSubquery() {
        return !this.pushable;
    }

    public boolean hasMethodCall() {
        return !this.pushable;
    }

    public void markStartKey() {
        this.startKey = true;
    }

    public boolean isStartKey() {
        return this.startKey;
    }

    public void markStopKey() {
        this.stopKey = true;
    }

    public boolean isStopKey() {
        return this.stopKey;
    }

    public void markQualifier() {
        this.isQualifier = true;
    }

    public boolean isQualifier() {
        return this.isQualifier;
    }

    public boolean compareWithKnownConstant(Optimizable optTable, boolean considerParameters) {
        boolean retval = false;
        RelationalOperator relop = this.getRelop();
        if (!this.isRelationalOpPredicate()) {
            return false;
        }
        if (relop.compareWithKnownConstant(optTable, considerParameters)) {
            retval = true;
        }
        return retval;
    }

    public int hasEqualOnColumnList(int[] baseColumnPositions, Optimizable optTable) throws StandardException {
        RelationalOperator relop = this.getRelop();
        if (!this.isRelationalOpPredicate()) {
            return -1;
        }
        if (relop.getOperator() != 1) {
            return -1;
        }
        for (int i = 0; i < baseColumnPositions.length; ++i) {
            ColumnReference cr = relop.getColumnOperand(optTable, baseColumnPositions[i]);
            if (cr == null || relop.selfComparison(cr)) continue;
            return i;
        }
        return -1;
    }

    public DataValueDescriptor getCompareValue(Optimizable optTable) throws StandardException {
        SanityManager.ASSERT(this.compareWithKnownConstant(optTable, true), "Cannot get the compare value if not comparing with a known constant.");
        RelationalOperator relop = this.getRelop();
        return relop.getCompareValue(optTable);
    }

    public boolean equalsComparisonWithConstantExpression(Optimizable optTable) {
        boolean retval = false;
        if (this.isRelationalOpPredicate()) {
            retval = this.getRelop().equalsComparisonWithConstantExpression(optTable);
        }
        return retval;
    }

    public double selectivity(Optimizable optTable) throws StandardException {
        return this.andNode.getLeftOperand().selectivity(optTable);
    }

    public int getIndexPosition() {
        return this.indexPosition;
    }

    public int compareTo(Object other) {
        boolean otherIsBefore;
        boolean thisIsBefore;
        Predicate otherPred = (Predicate)other;
        int otherIndexPosition = otherPred.getIndexPosition();
        if (this.indexPosition < otherIndexPosition) {
            return -1;
        }
        if (this.indexPosition > otherIndexPosition) {
            return 1;
        }
        boolean thisIsEquals = false;
        boolean otherIsEquals = false;
        boolean thisIsNotEquals = true;
        boolean otherIsNotEquals = true;
        if (this.isRelationalOpPredicate() || this.isInListProbePredicate()) {
            int thisOperator = ((RelationalOperator)((Object)this.andNode.getLeftOperand())).getOperator();
            thisIsEquals = thisOperator == 1 || thisOperator == 7;
            boolean bl = thisIsNotEquals = thisOperator == 2 || thisOperator == 8;
        }
        if (otherPred.isRelationalOpPredicate() || otherPred.isInListProbePredicate()) {
            int otherOperator = ((RelationalOperator)((Object)otherPred.getAndNode().getLeftOperand())).getOperator();
            otherIsEquals = otherOperator == 1 || otherOperator == 7;
            otherIsNotEquals = otherOperator == 2 || otherOperator == 8;
        }
        boolean bl = thisIsBefore = thisIsEquals && !otherIsEquals || !thisIsNotEquals && otherIsNotEquals;
        if (thisIsBefore) {
            return -1;
        }
        boolean bl2 = otherIsBefore = otherIsEquals && !thisIsEquals || !otherIsNotEquals && thisIsNotEquals;
        if (otherIsBefore) {
            return 1;
        }
        return 0;
    }

    public AndNode getAndNode() {
        return this.andNode;
    }

    public void setAndNode(AndNode andNode) {
        this.andNode = andNode;
    }

    public boolean getPushable() {
        return this.pushable;
    }

    public void setPushable(boolean pushable) {
        this.pushable = pushable;
    }

    public JBitSet getReferencedSet() {
        return this.referencedSet;
    }

    void setEquivalenceClass(int equivalenceClass) {
        this.equivalenceClass = equivalenceClass;
    }

    int getEquivalenceClass() {
        return this.equivalenceClass;
    }

    public void categorize() throws StandardException {
        this.pushable = this.andNode.categorize(this.referencedSet, false);
    }

    public RelationalOperator getRelop() {
        if (this.andNode.getLeftOperand() instanceof RelationalOperator) {
            return (RelationalOperator)((Object)this.andNode.getLeftOperand());
        }
        return null;
    }

    public final boolean isOrList() {
        return this.andNode.getLeftOperand() instanceof OrNode;
    }

    public final boolean isStoreQualifier() {
        return this.andNode.getLeftOperand() instanceof RelationalOperator || this.andNode.getLeftOperand() instanceof OrNode;
    }

    public final boolean isPushableOrClause(Optimizable optTable) throws StandardException {
        boolean ret_val = true;
        if (this.andNode.getLeftOperand() instanceof OrNode) {
            ValueNode node = this.andNode.getLeftOperand();
            while (node instanceof OrNode) {
                OrNode or_node = (OrNode)node;
                if (or_node.getLeftOperand() instanceof RelationalOperator) {
                    if (!((RelationalOperator)((Object)or_node.getLeftOperand())).isQualifier(optTable, true)) {
                        return false;
                    }
                    node = or_node.getRightOperand();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    boolean transitiveSearchClauseAdded(RelationalOperator ro) {
        return this.searchClauseHT != null && this.searchClauseHT.get(new Integer(ro.getOperator())) != null;
    }

    void setTransitiveSearchClauseAdded(RelationalOperator ro) {
        if (this.searchClauseHT == null) {
            this.searchClauseHT = new Hashtable();
        }
        Integer i = new Integer(ro.getOperator());
        this.searchClauseHT.put(i, i);
    }

    int getStartOperator(Optimizable optTable) {
        SanityManager.ASSERT(this.startKey, "Getting a start operator from a Predicate that's not a start key.");
        if (this.andNode.getLeftOperand() instanceof InListOperatorNode) {
            return 1;
        }
        return this.getRelop().getStartOperator(optTable);
    }

    int getStopOperator(Optimizable optTable) {
        SanityManager.ASSERT(this.stopKey, "Getting a stop operator from a Predicate that's not a stop key.");
        if (this.andNode.getLeftOperand() instanceof InListOperatorNode) {
            return -1;
        }
        return this.getRelop().getStopOperator(optTable);
    }

    void setIndexPosition(int indexPosition) {
        this.indexPosition = indexPosition;
    }

    void clearScanFlags() {
        this.startKey = false;
        this.stopKey = false;
        this.isQualifier = false;
    }

    void clearQualifierFlag() {
        this.isQualifier = false;
    }

    void generateExpressionOperand(Optimizable optTable, int columnPosition, ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.getRelop().generateExpressionOperand(optTable, columnPosition, acb, mb);
    }

    void generateAbsoluteColumnId(MethodBuilder mb, Optimizable optTable) {
        this.getRelop().generateAbsoluteColumnId(mb, optTable);
    }

    void generateRelativeColumnId(MethodBuilder mb, Optimizable optTable) {
        this.getRelop().generateRelativeColumnId(mb, optTable);
    }

    void generateOperator(MethodBuilder mb, Optimizable optTable) {
        this.getRelop().generateOperator(mb, optTable);
    }

    void generateQualMethod(ExpressionClassBuilder acb, MethodBuilder mb, Optimizable optTable) throws StandardException {
        this.getRelop().generateQualMethod(acb, mb, optTable);
    }

    void generateOrderedNulls(MethodBuilder mb) {
        this.getRelop().generateOrderedNulls(mb);
    }

    void generateNegate(MethodBuilder mb, Optimizable optTable) {
        this.getRelop().generateNegate(mb, optTable);
    }

    void generateOrderableVariantType(MethodBuilder mb, Optimizable optTable) throws StandardException {
        int variantType = this.getRelop().getOrderableVariantType(optTable);
        mb.push(variantType);
    }

    public String toString() {
        return this.binaryRelOpColRefsToString() + "\nreferencedSet: " + this.referencedSet + "\n" + "pushable: " + this.pushable + "\n" + super.toString();
    }

    public String binaryRelOpColRefsToString() {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return "";
        }
        String DUMMY_VAL = "<expr>";
        StringBuffer sBuf = new StringBuffer();
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        if (opNode.getLeftOperand() instanceof ColumnReference) {
            sBuf.append(((ColumnReference)opNode.getLeftOperand()).getTableName() + "." + ((ColumnReference)opNode.getLeftOperand()).getColumnName());
        } else {
            sBuf.append("<expr>");
        }
        sBuf.append(" " + opNode.operator + " ");
        if (opNode.getRightOperand() instanceof ColumnReference) {
            sBuf.append(((ColumnReference)opNode.getRightOperand()).getTableName() + "." + ((ColumnReference)opNode.getRightOperand()).getColumnName());
        } else {
            sBuf.append("<expr>");
        }
        return sBuf.toString();
    }

    public void printSubNodes(int depth) {
        this.printLabel(depth, "andNode: ");
        this.andNode.treePrint(depth + 1);
        super.printSubNodes(depth);
    }

    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.andNode != null && !v.stopTraversal()) {
            this.andNode = (AndNode)this.andNode.accept(v);
        }
        return returnNode;
    }

    public void copyFields(Predicate otherPred) {
        this.equivalenceClass = otherPred.getEquivalenceClass();
        this.indexPosition = otherPred.getIndexPosition();
        this.startKey = otherPred.isStartKey();
        this.stopKey = otherPred.isStopKey();
        this.isQualifier = otherPred.isQualifier();
        this.searchClauseHT = otherPred.getSearchClauseHT();
    }

    public Hashtable getSearchClauseHT() {
        return this.searchClauseHT;
    }

    protected boolean pushableToSubqueries() throws StandardException {
        if (!this.isJoinPredicate()) {
            return false;
        }
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        JBitSet tNums = new JBitSet(this.getReferencedSet().size());
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(tNums);
        opNode.getLeftOperand().accept(btnVis);
        if (tNums.getFirstSetBit() == -1) {
            return false;
        }
        tNums.clearAll();
        opNode.getRightOperand().accept(btnVis);
        return tNums.getFirstSetBit() != -1;
    }

    protected boolean isJoinPredicate() {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return false;
        }
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        return opNode.getLeftOperand() instanceof ColumnReference && opNode.getRightOperand() instanceof ColumnReference && ((ColumnReference)opNode.getLeftOperand()).getTableNumber() != ((ColumnReference)opNode.getRightOperand()).getTableNumber();
    }

    protected Predicate getPredScopedForResultSet(JBitSet parentRSNsTables, ResultSetNode childRSN, int[] whichRC) throws StandardException {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return this;
        }
        ValueNode trueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        BinaryRelationalOperatorNode newOpNode = (BinaryRelationalOperatorNode)this.getNodeFactory().getNode(opNode.getNodeType(), opNode.getScopedOperand(-1, parentRSNsTables, childRSN, whichRC), opNode.getScopedOperand(1, parentRSNsTables, childRSN, whichRC), this.getContextManager());
        newOpNode.bindComparisonOperator();
        AndNode newAnd = (AndNode)this.getNodeFactory().getNode(39, newOpNode, trueNode, this.getContextManager());
        newAnd.postBindFixup();
        JBitSet tableMap = new JBitSet(childRSN.getReferencedTableMap().size());
        newAnd.categorize(tableMap, false);
        Predicate newPred = (Predicate)this.getNodeFactory().getNode(78, newAnd, tableMap, this.getContextManager());
        newPred.clearScanFlags();
        newPred.copyFields(this);
        newPred.setPushable(this.getPushable());
        newPred.markAsScopedForPush();
        return newPred;
    }

    protected void markAsScopedForPush() {
        this.scoped = true;
    }

    protected boolean isScopedForPush() {
        return this.scoped;
    }

    protected boolean remapScopedPred() {
        if (!this.scoped) {
            return false;
        }
        BinaryRelationalOperatorNode binRelOp = (BinaryRelationalOperatorNode)this.andNode.getLeftOperand();
        ValueNode operand = null;
        operand = binRelOp.getLeftOperand();
        boolean leftIsScoped = !(operand instanceof ColumnReference) || ((ColumnReference)operand).isScoped();
        operand = binRelOp.getRightOperand();
        boolean rightIsScoped = !(operand instanceof ColumnReference) || ((ColumnReference)operand).isScoped();
        SanityManager.ASSERT(leftIsScoped ^ rightIsScoped, "All scoped predicates should have exactly one scoped operand, but '" + this.binaryRelOpColRefsToString() + "' has " + (leftIsScoped ? "TWO" : "NONE") + ".");
        operand = binRelOp.getLeftOperand();
        if (operand instanceof ColumnReference && ((ColumnReference)operand).isScoped()) {
            ((ColumnReference)operand).remapColumnReferences();
        } else {
            operand = binRelOp.getRightOperand();
            if (operand instanceof ColumnReference && ((ColumnReference)operand).isScoped()) {
                ((ColumnReference)operand).remapColumnReferences();
            }
        }
        return true;
    }

    protected boolean isScopedToSourceResultSet() throws StandardException {
        if (!this.scoped) {
            return false;
        }
        BinaryRelationalOperatorNode binRelOp = (BinaryRelationalOperatorNode)this.andNode.getLeftOperand();
        ValueNode operand = binRelOp.getLeftOperand();
        if (!(operand instanceof ColumnReference)) {
            return false;
        }
        ValueNode exp = null;
        ColumnReference cRef = (ColumnReference)operand;
        if (cRef.isScoped()) {
            exp = cRef.getSource().getExpression();
            return exp instanceof VirtualColumnNode || exp instanceof ColumnReference;
        }
        operand = binRelOp.getRightOperand();
        if (!(operand instanceof ColumnReference)) {
            return false;
        }
        cRef = (ColumnReference)operand;
        SanityManager.ASSERT(cRef.isScoped(), "All scoped predicates should have exactly one scoped operand, but '" + this.binaryRelOpColRefsToString() + "has NONE.");
        exp = cRef.getSource().getExpression();
        return exp instanceof VirtualColumnNode || exp instanceof ColumnReference;
    }

    protected boolean isRelationalOpPredicate() {
        return this.andNode.getLeftOperand().isRelationalOperator();
    }

    protected boolean isInListProbePredicate() {
        return this.andNode.getLeftOperand().isInListProbeNode();
    }

    protected InListOperatorNode getSourceInList() {
        return this.getSourceInList(false);
    }

    protected InListOperatorNode getSourceInList(boolean probePredOnly) {
        ValueNode vn = this.andNode.getLeftOperand();
        if (this.isInListProbePredicate()) {
            return ((BinaryRelationalOperatorNode)vn).getInListOp();
        }
        if (probePredOnly) {
            return null;
        }
        if (vn instanceof InListOperatorNode) {
            return (InListOperatorNode)vn;
        }
        return null;
    }
}

