/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.TaskLog;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.output.OutputMode;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.util.Counters;

public class TaskContextImpl
implements TaskContext {
    private final Task _task;
    private final Inputs _inputs;
    private final Outputs _outputs;
    private final Map<String, Number> _workerDurations = new HashMap<String, Number>();
    private final Map<String, Number> _workerCounters = new HashMap<String, Number>();
    private boolean _canceled;
    private final TaskLog _taskLog;
    private final ObjectStoreService _objectStore;

    public TaskContextImpl(Task task, TaskLog taskLog, ObjectStoreService objectStore) {
        this(task, taskLog, objectStore, new HashMap<String, Collection<OutputMode>>(0));
    }

    public TaskContextImpl(Task task, TaskLog taskLog, ObjectStoreService objectStore, Map<String, Collection<OutputMode>> outputModes) {
        this._task = task;
        this._taskLog = taskLog;
        this._objectStore = objectStore;
        this._inputs = new Inputs(task.getInputBulks(), objectStore);
        this._outputs = new Outputs(task.getOutputBulks(), objectStore);
        this._outputs.setOutputModes(outputModes);
    }

    @Override
    public Task getTask() {
        return this._task;
    }

    @Override
    public AnyMap getTaskParameters() {
        return this._task.getParameters();
    }

    @Override
    public Inputs getInputs() {
        return this._inputs;
    }

    @Override
    public Outputs getOutputs() {
        return this._outputs;
    }

    @Override
    public Map<String, Number> getFinalCounters() {
        HashMap<String, Number> counters = new HashMap<String, Number>();
        Counters.add(counters, "warnCount", this._taskLog.getWarnCount());
        this._inputs.addInputCounters(counters);
        this._outputs.addOutputCounters(counters);
        if (counters.containsKey("duration.iodata.close")) {
            Counters.add(counters, "duration.iodata", ((Number)counters.get("duration.iodata.close")).doubleValue());
        }
        if (counters.containsKey("duration.iodata.open")) {
            Counters.add(counters, "duration.iodata", ((Number)counters.get("duration.iodata.open")).doubleValue());
        }
        if (!this._workerDurations.isEmpty()) {
            Counters.addAll(counters, this._workerDurations, "duration.perform.function");
        }
        if (!this._workerCounters.isEmpty()) {
            Counters.addAll(counters, this._workerCounters, "function");
        }
        return counters;
    }

    @Override
    public void addToCounter(String name, long value) {
        Counters.add(this._workerCounters, name, value);
    }

    @Override
    public void addToCounter(String name, double value) {
        Counters.add(this._workerCounters, name, value);
    }

    @Override
    public long getTimestamp() {
        return System.nanoTime();
    }

    @Override
    public void measureTime(String name, long startTime) {
        long duration = System.nanoTime() - startTime;
        this.addDuration(name, duration);
    }

    @Override
    public void addDuration(String name, long duration) {
        Counters.addDuration(this._workerDurations, name, duration);
    }

    @Override
    public void addDuration(String name, double duration) {
        Counters.add(this._workerDurations, name, duration);
    }

    @Override
    public boolean isCanceled() {
        return this._canceled;
    }

    @Override
    public void cancel() {
        this._canceled = true;
    }

    @Override
    public ObjectStoreService getObjectStore() {
        return this._objectStore;
    }

    @Override
    public TaskLog getLog() {
        return this._taskLog;
    }
}

