/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.impl.failover;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.eclipse.smila.http.client.impl.base.HttpRequestExecutor;

public class FailoverHttpRequestExecutor
implements HttpRequestExecutor {
    private final List<HttpHost> _httpHosts;
    private int _currentHostIndex;
    private final Log _log = LogFactory.getLog(this.getClass());

    public FailoverHttpRequestExecutor(List<String> hostsAndPorts) {
        this._httpHosts = this.convertHostAndPorts(hostsAndPorts);
    }

    private List<HttpHost> convertHostAndPorts(List<String> hostsAndPorts) {
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(hostsAndPorts.size());
        for (String hostAndPort : hostsAndPorts) {
            if (hostAndPort.toLowerCase().startsWith("http://")) {
                hostAndPort = hostAndPort.substring("http://".length());
            }
            String[] hostPortSplit = hostAndPort.split(":");
            int port = Integer.parseInt(hostPortSplit[1]);
            httpHosts.add(new HttpHost(hostPortSplit[0], port));
        }
        return httpHosts;
    }

    @Override
    public String getHostAndPort() {
        HttpHost currentHost = this._httpHosts.get(this._currentHostIndex);
        return currentHost.toString();
    }

    @Override
    public HttpResponse execute(HttpClient client, HttpUriRequest request) throws IOException {
        RequestWrapper wrappedRequest = this.wrapRequest(request);
        int usedHostIndex = 0;
        while (wrappedRequest.getExecCount() < this._httpHosts.size()) {
            try {
                usedHostIndex = this.setActualUri(wrappedRequest);
                wrappedRequest.incrementExecCount();
                return client.execute((HttpUriRequest)wrappedRequest);
            }
            catch (IOException ex) {
                this.handleIOException(wrappedRequest, usedHostIndex, ex);
            }
        }
        throw new NoHttpResponseException("No response received from any HTTP server for " + wrappedRequest.getURI());
    }

    private void handleIOException(RequestWrapper wrappedRequest, int usedHostIndex, IOException ex) throws ConnectException {
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)("Request to " + wrappedRequest.getURI() + " failed"), (Throwable)ex);
        }
        this.failoverToNextHost(usedHostIndex);
        if (!wrappedRequest.isRepeatable()) {
            throw new ConnectException("Request to " + wrappedRequest.getURI() + " is not repeatable anymore after " + ex.toString());
        }
    }

    private RequestWrapper wrapRequest(HttpUriRequest request) {
        try {
            if (request instanceof HttpEntityEnclosingRequest) {
                return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
            }
            return new RequestWrapper((HttpRequest)request);
        }
        catch (ProtocolException ex) {
            throw new IllegalArgumentException("Invalid request", ex);
        }
    }

    private int setActualUri(RequestWrapper wrappedRequest) {
        URI uri = wrappedRequest.getURI();
        try {
            int actualHostIndex = this._currentHostIndex;
            URI actualUri = URIUtils.rewriteURI((URI)uri, (HttpHost)this._httpHosts.get(actualHostIndex));
            wrappedRequest.setURI(actualUri);
            return actualHostIndex;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Cannot rewrite invalid URI", ex);
        }
    }

    private synchronized void failoverToNextHost(int failedHostIndex) {
        if (failedHostIndex == this._currentHostIndex) {
            if (++this._currentHostIndex >= this._httpHosts.size()) {
                this._currentHostIndex = 0;
            }
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Failover to " + this.getHostAndPort()));
            }
        } else if (this._log.isInfoEnabled()) {
            this._log.info((Object)"Failover already done");
        }
    }
}

