/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class ExecPipelet
implements Pipelet {
    public static final String COMMAND_PROPERTY = "command";
    public static final String DIRECTORY_PROPERTY = "directory";
    public static final String PARAMETERS_PROPERTY = "parameters";
    public static final String PARAMETERS_ATTRIBUTE_PROPERTY = "parametersAttribute";
    public static final String INPUT_ATTACHMENT_PROPERTY = "inputAttachment";
    public static final String OUTPUT_ATTACHMENT_PROPERTY = "outputAttachment";
    public static final String ERROR_ATTACHMENT_PROPERTY = "errorAttachment";
    public static final String EXIT_CODE_ATTRIBUTE_PROPERTY = "exitCodeAttribute";
    public static final String FAIL_ON_ERROR_PROPERTY = "failOnError";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _config;
    private String _command;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._config = configuration;
        ParameterAccessor paramAccessor = new ParameterAccessor(configuration);
        this._command = paramAccessor.getRequiredParameter(COMMAND_PROPERTY);
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(this._config);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        String[] cmdArray = new String[]{this._command};
        Any previousParameters = null;
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String recordId = stringArray[n2];
            try {
                String directory;
                paramAccessor.setCurrentRecord(recordId);
                String parametersAttribute = paramAccessor.getParameter(PARAMETERS_ATTRIBUTE_PROPERTY, null);
                Any parameters = null;
                if (parametersAttribute != null) {
                    parameters = (Any)blackboard.getMetadata(recordId).get((Object)parametersAttribute);
                }
                if (parameters == null) {
                    parameters = paramAccessor.getParameterAny(PARAMETERS_PROPERTY);
                }
                if (parameters != previousParameters) {
                    if (parameters == null) {
                        cmdArray = new String[]{this._command};
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(this._command);
                        if (parameters.isValue()) {
                            StringTokenizer tokenizer = new StringTokenizer(this._command);
                            while (tokenizer.hasMoreTokens()) {
                                list.add(tokenizer.nextToken());
                            }
                        } else if (parameters.isSeq()) {
                            list.addAll(parameters.asSeq().asStrings());
                        }
                        cmdArray = list.toArray(new String[list.size()]);
                    }
                    previousParameters = parameters;
                }
                File wd = (directory = paramAccessor.getParameter(DIRECTORY_PROPERTY, null)) == null ? null : new File(directory);
                Process process = Runtime.getRuntime().exec(cmdArray, null, wd);
                this.sendInput(blackboard, paramAccessor, recordId, process);
                this.receiveOutput(blackboard, paramAccessor, recordId, process, cmdArray);
                resultCollector.addResult(recordId);
            }
            catch (Exception e) {
                resultCollector.addFailedResult(recordId, e instanceof ProcessingException ? e : new ProcessingException("Error in ExecPipelet processing id " + recordId, (Throwable)e));
            }
            ++n2;
        }
        return recordIds;
    }

    private void receiveOutput(Blackboard blackboard, ParameterAccessor paramAccessor, String recordId, Process process, String[] cmdArray) throws InterruptedException, BlackboardAccessException, UnsupportedEncodingException, ProcessingException {
        ProcessStreamThread outputThread = new ProcessStreamThread(process.getInputStream(), paramAccessor.getParameter(OUTPUT_ATTACHMENT_PROPERTY, null));
        outputThread.start();
        ProcessStreamThread errorThread = new ProcessStreamThread(process.getErrorStream(), paramAccessor.getParameter(ERROR_ATTACHMENT_PROPERTY, null));
        Any failOnError = paramAccessor.getParameterAny(FAIL_ON_ERROR_PROPERTY);
        if (failOnError != null && errorThread._outputAttachment == null) {
            errorThread._out = new ByteArrayOutputStream();
        }
        errorThread.start();
        int exitValue = process.waitFor();
        String exitCodeAttribute = paramAccessor.getParameter(EXIT_CODE_ATTRIBUTE_PROPERTY, null);
        if (exitCodeAttribute != null) {
            blackboard.getMetadata(recordId).put(exitCodeAttribute, (Number)exitValue);
        }
        outputThread.save(blackboard, recordId);
        errorThread.save(blackboard, recordId);
        if (this.contains(failOnError, exitValue)) {
            String message = "Execution of\n  " + Arrays.toString(cmdArray) + "\nfailed with exit code " + exitValue;
            if (errorThread._out instanceof ByteArrayOutputStream) {
                errorThread.waitFor();
                ByteArrayOutputStream out = (ByteArrayOutputStream)errorThread._out;
                if (out.size() > 0) {
                    message = String.valueOf(message) + "\nMessage:\n" + new String(out.toByteArray(), "ISO-8859-1");
                }
            }
            throw new ProcessingException(message);
        }
    }

    private void sendInput(Blackboard blackboard, ParameterAccessor paramAccessor, String recordId, Process process) throws BlackboardAccessException, UnsupportedEncodingException {
        String inputAttribute = paramAccessor.getParameter(INPUT_ATTACHMENT_PROPERTY, null);
        if (inputAttribute != null) {
            InputStream in = blackboard.getAttachmentAsStream(recordId, inputAttribute);
            if (in != null) {
                new ProcessStreamThread(in, process.getOutputStream()).start();
            } else {
                String input = blackboard.getMetadata(recordId).getStringValue(inputAttribute);
                if (input != null) {
                    new ProcessStreamThread((InputStream)new ByteArrayInputStream(input.getBytes("ISO-8859-1")), process.getOutputStream()).start();
                }
            }
        }
    }

    private boolean contains(Any parameter, int value) {
        if (parameter == null) {
            return false;
        }
        if (parameter.isBoolean()) {
            return parameter.asValue().asBoolean() != false && value != 0;
        }
        for (Any entry : parameter) {
            if (!(entry.isNumber() ? entry.asValue().asLong() == (long)value : entry.isString() && this.contains(entry.toString(), value))) continue;
            return true;
        }
        return false;
    }

    private boolean contains(String range, int value) {
        int max;
        int dash = range.indexOf(45);
        if (dash < 0) {
            return Integer.parseInt(range) == value;
        }
        int min = dash == 0 ? Integer.MIN_VALUE : Integer.parseInt(range.substring(0, dash));
        int n = max = dash + 1 == range.length() ? Integer.MAX_VALUE : Integer.parseInt(range.substring(dash + 1));
        return value >= min && value <= max;
    }

    private final class ProcessStreamThread
    extends Thread {
        private final InputStream _in;
        private OutputStream _out;
        private final String _outputAttachment;

        private ProcessStreamThread(InputStream in, String outputAttachment) {
            this._in = in;
            this._outputAttachment = outputAttachment;
            this._out = outputAttachment != null ? new ByteArrayOutputStream() : null;
        }

        private ProcessStreamThread(InputStream in, OutputStream out) {
            this._in = in;
            this._out = out;
            this._outputAttachment = null;
        }

        @Override
        public void run() {
            try {
                int i = this._in.read();
                while (i >= 0) {
                    if (this._out != null) {
                        this._out.write(i);
                    }
                    i = this._in.read();
                }
            }
            catch (IOException e) {
                ExecPipelet.this._log.warn((Object)"Error during evaluation of the output of an executed proces.", (Throwable)e);
            }
        }

        public void save(Blackboard blackboard, String recordId) throws BlackboardAccessException {
            if (this._outputAttachment != null) {
                this.waitFor();
                blackboard.setAttachment(recordId, this._outputAttachment, ((ByteArrayOutputStream)this._out).toByteArray());
            }
        }

        private void waitFor() {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

