/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class ScriptPipelet
implements Pipelet {
    public static final String PROPERTY_SCRIPT = "script";
    public static final String PROPERTY_SCRIPT_FILE = "scriptFile";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_RESULT_ATTRIBUTE = "resultAttribute";
    private static final String BLACKBOARD_VARIABLE = "blackboard";
    private static final String ID_VARIABLE = "id";
    private static final String METADATA_VARIABLE = "record";
    private static final String RESULTS_VARIABLE = "results";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _configuration;
    private File _scriptFile;
    private long _fileLastModified;
    private String _script;
    private ScriptEngine _engine;
    private ScriptEngineManager _engines;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
        ParameterAccessor paramAccessor = new ParameterAccessor(null, configuration);
        String scriptFile = paramAccessor.getParameter(PROPERTY_SCRIPT_FILE, null);
        if (scriptFile != null) {
            this._scriptFile = new File(scriptFile);
            if (!this._scriptFile.isFile()) {
                throw new ProcessingException("Could not find script file: " + this._scriptFile.getAbsolutePath());
            }
        } else {
            this._script = paramAccessor.getRequiredParameter(PROPERTY_SCRIPT);
        }
        this._engines = new ScriptEngineManager();
        this._engine = this._engines.getEngineByMimeType(paramAccessor.getParameter(PROPERTY_TYPE, "text/javascript"));
        if (this._engine.getFactory().getParameter("THREADING") == null) {
            this._engine = null;
        } else {
            this._engine.put("javax.script.filename", scriptFile != null ? scriptFile : "<inline script>");
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._configuration);
        ResultIDs resultCollector = new ResultIDs(paramAccessor, this._log, false);
        if (recordIds != null) {
            ScriptEngine engine = this._engine;
            if (engine == null) {
                engine = this._engines.getEngineByMimeType(paramAccessor.getParameter(PROPERTY_TYPE, "text/javascript"));
            }
            this.checkScriptModification();
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    paramAccessor.setCurrentRecord(id);
                    resultCollector._excludeCurrentRecord = false;
                    Bindings bindings = engine.createBindings();
                    AnyMap metadata = blackboard.getMetadata(id);
                    bindings.put(BLACKBOARD_VARIABLE, (Object)blackboard);
                    bindings.put(ID_VARIABLE, (Object)id);
                    bindings.put(METADATA_VARIABLE, (Object)metadata);
                    bindings.put(RESULTS_VARIABLE, (Object)resultCollector);
                    Object result = engine.eval(this._script, bindings);
                    if (!resultCollector._excludeCurrentRecord) {
                        String resultAttribute = paramAccessor.getParameter(PROPERTY_RESULT_ATTRIBUTE, null);
                        if (resultAttribute != null) {
                            if (result == null) {
                                metadata.remove((Object)resultAttribute);
                            } else {
                                metadata.put(resultAttribute, ScriptPipelet.convertObject(result));
                            }
                        }
                        resultCollector.addResult(id);
                    }
                }
                catch (Exception e) {
                    resultCollector.addFailedResult(id, e);
                }
                ++n2;
            }
        }
        return resultCollector.getResultIds();
    }

    private void checkScriptModification() throws ProcessingException {
        if (this._scriptFile != null && (this._script == null || this._fileLastModified != this._scriptFile.lastModified())) {
            if (this._script == null) {
                this._script = "";
            }
            this._fileLastModified = this._scriptFile.lastModified();
            try (FileInputStream in = new FileInputStream(this._scriptFile);){
                this._script = IOUtils.toString((InputStream)in);
            }
            catch (IOException e) {
                throw new ProcessingException("Could not read script file: " + this._scriptFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private static Any convertObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Any) {
            return (Any)object;
        }
        if (object instanceof Map) {
            return ScriptPipelet.convertMap((Map)object);
        }
        if (object instanceof Iterable) {
            return ScriptPipelet.convertCollection((Iterable)object);
        }
        if (object instanceof Object[]) {
            return ScriptPipelet.convertCollection(Arrays.asList((Object[])object));
        }
        try {
            return DataFactory.DEFAULT.autoConvertValue(object);
        }
        catch (InvalidValueTypeException invalidValueTypeException) {
            return DataFactory.DEFAULT.createStringValue(object.toString());
        }
    }

    private static Any convertCollection(Iterable<?> collection) {
        AnySeq result = DataFactory.DEFAULT.createAnySeq();
        for (Object o : collection) {
            if (o == null) continue;
            result.add((Object)ScriptPipelet.convertObject(o));
        }
        return result;
    }

    private static AnyMap convertMap(Map<?, ?> map) {
        AnyMap result = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            result.put(entry.getKey().toString(), ScriptPipelet.convertObject(entry.getValue()));
        }
        return result;
    }

    public static final class ResultIDs
    extends ResultCollector {
        private boolean _excludeCurrentRecord;

        public ResultIDs(ParameterAccessor paramAccessor, Log log, boolean dropRecordOnError) {
            super(paramAccessor, log, dropRecordOnError);
        }

        public void excludeCurrentRecord() {
            this._excludeCurrentRecord = true;
        }
    }
}

