/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.counter;

import org.eclipse.smila.management.LocatedManagementAgent;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementRegistration;
import org.eclipse.smila.processing.bpel.counter.ProcessingPerformanceCounterAgent;

public abstract class ProcessingPerformanceCounter {
    private static final int NANOS_IN_MILLIS = 1000000;
    private final String _elementName;
    private final ProcessingPerformanceCounterAgent _agent;

    public ProcessingPerformanceCounter(String elementName) {
        this._elementName = elementName;
        this._agent = new ProcessingPerformanceCounterAgent();
    }

    protected void registerAgent() {
        this._agent.setLocation(this.getLocation());
        ManagementRegistration.INSTANCE.registerAgent((LocatedManagementAgent)this._agent);
    }

    protected abstract String getElementType();

    protected String getElementName() {
        return this._elementName;
    }

    public void countSuccessMillis(long executionTime, int incomingRecords, int outgoingRecords) {
        this._agent.getInvocations().increment();
        this._agent.getAverageExecutionTime().incrementBy(executionTime);
        this._agent.getIncomingRecords().incrementBy((long)incomingRecords);
        this._agent.getOutgoingRecords().incrementBy((long)outgoingRecords);
    }

    public void countSuccessNanos(long executionTime, int incomingRecords, int outgoingRecords) {
        this.countSuccessMillis(executionTime / 1000000L, incomingRecords, outgoingRecords);
    }

    public void countFailureMillis(long executionTime, int incomingRecords, int outgoingRecords) {
        this._agent.getInvocations().increment();
        this._agent.getFailures().increment();
        this._agent.getAverageExecutionTime().incrementBy(executionTime);
        this._agent.getIncomingRecords().incrementBy((long)incomingRecords);
        this._agent.getOutgoingRecords().incrementBy((long)outgoingRecords);
    }

    public void countFailureNanos(long executionTime, int incomingRecords, int outgoingRecords) {
        this.countFailureMillis(executionTime / 1000000L, incomingRecords, outgoingRecords);
    }

    public void countInvocationMillis(long executionTime, boolean success, int incomingRecords, int outgoingRecords) {
        if (success) {
            this.countSuccessMillis(executionTime, incomingRecords, outgoingRecords);
        } else {
            this.countFailureMillis(executionTime, incomingRecords, outgoingRecords);
        }
    }

    public void countInvocationNanos(long executionTime, boolean success, int incomingRecords, int outgoingRecords) {
        this.countInvocationMillis(executionTime / 1000000L, success, incomingRecords, outgoingRecords);
    }

    public void countIds(int incomingRecords, int outgoingRecords) {
        this._agent.getIncomingRecords().incrementBy((long)incomingRecords);
        this._agent.getOutgoingRecords().incrementBy((long)outgoingRecords);
    }

    public void addError(Throwable ex, boolean isCritical) {
        this._agent.getErrorsBuffer().addError(ex, isCritical);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Performance of ").append(this._elementName).append(": ");
        builder.append("total = ").append(this._agent.getInvocations().getNextValue());
        builder.append(", average time = ").append(this._agent.getAverageExecutionTime().getNextValue());
        builder.append("ms, failures = ").append(this._agent.getFailures().getNextValue());
        builder.append(", incomingRecords = ").append(this._agent.getIncomingRecords().getNextValue());
        builder.append(", outgoingRecords = ").append(this._agent.getOutgoingRecords().getNextValue());
        return builder.toString();
    }

    public abstract ManagementAgentLocation getLocation();
}

