/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.scriptexecution;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;

public final class LogHelper {
    private LogHelper() {
    }

    public static void debug(Log log, InputStream inputStream) throws IOException {
        LogHelper.log(log, inputStream, LogLevel.DEBUG);
    }

    public static void info(Log log, InputStream inputStream) throws IOException {
        LogHelper.log(log, inputStream, LogLevel.INFO);
    }

    public static void warn(Log log, InputStream inputStream) throws IOException {
        LogHelper.log(log, inputStream, LogLevel.WARN);
    }

    public static void error(Log log, InputStream inputStream) throws IOException {
        LogHelper.log(log, inputStream, LogLevel.ERROR);
    }

    private static void log(Log log, InputStream inputStream, LogLevel logLevel) throws IOException {
        LineIterator lineIterator = IOUtils.lineIterator((InputStream)inputStream, null);
        while (lineIterator.hasNext()) {
            String string = lineIterator.nextLine();
            LogHelper.log(log, string, logLevel);
        }
    }

    private static void log(Log log, String message, LogLevel logLevel) {
        if (LogLevel.DEBUG.equals((Object)logLevel)) {
            log.debug((Object)message);
        } else if (LogLevel.INFO.equals((Object)logLevel)) {
            log.info((Object)message);
        } else if (LogLevel.WARN.equals((Object)logLevel)) {
            log.warn((Object)message);
        } else if (LogLevel.ERROR.equals((Object)logLevel)) {
            log.error((Object)message);
        } else {
            throw new IllegalArgumentException("Unknown log level [" + (Object)((Object)logLevel) + "]");
        }
    }

    private static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

