/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.axes.NodeSequence;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathUtils {
    private XPathUtils() {
    }

    public static Object queryForIndexField(Node node, String xpath, Node namespaceNode, String separator) {
        Log log = LogFactory.getLog(XPathUtils.class);
        try {
            XObject xobj = XPathAPI.eval((Node)node, (String)xpath, (Node)namespaceNode);
            if (xobj instanceof NodeSequence) {
                NodeList nlTemp = xobj.nodelist();
                StringBuffer sb = new StringBuffer("");
                int i = 0;
                while (i < nlTemp.getLength()) {
                    XObject value = XPathAPI.eval((Node)nlTemp.item(i), (String)"string()");
                    if (i > 0 && separator != null) {
                        sb.append(separator);
                    }
                    sb.append(value.str());
                    ++i;
                }
                return sb.toString();
            }
            if (xobj instanceof XBoolean) {
                return xobj.bool();
            }
            if (xobj instanceof XNumber) {
                return new Double(xobj.num());
            }
            if (xobj instanceof XRTreeFrag) {
                return xobj.str();
            }
            if (xobj instanceof XString) {
                return xobj.str();
            }
            throw new Exception("unsupported xpath return type [" + xobj.getClass().getName() + "]");
        }
        catch (Exception e) {
            log.error((Object)"unkown error occured", (Throwable)e);
            return null;
        }
    }

    public static void removeNodesByXPath(Node node, String xpath, Node namespaceNode) {
        block4: {
            Log log = LogFactory.getLog(XPathUtils.class);
            try {
                XObject xobj = XPathAPI.eval((Node)node, (String)xpath, (Node)namespaceNode);
                if (xobj instanceof NodeSequence) {
                    NodeList nlTemp = xobj.nodelist();
                    int i = 0;
                    while (i < nlTemp.getLength()) {
                        Node parent = nlTemp.item(i).getParentNode();
                        parent.removeChild(nlTemp.item(i));
                        ++i;
                    }
                    break block4;
                }
                throw new Exception("unsupported xpath return type [" + xobj.getClass().getName() + "]");
            }
            catch (Exception e) {
                log.error((Object)"unkown error occured", (Throwable)e);
            }
        }
    }
}

