/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.definitions.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class DataObjectTypeHandler
extends AJobManagerHandler {
    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        DataObjectTypeDefinition dot;
        String name = this.getName(requestUri);
        boolean returnDetails = false;
        DefinitionPersistence defPersistence = this.getDefinitionPersistence();
        if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)"returnDetails")) {
            returnDetails = inputRecord.getMetadata().getBooleanValue("returnDetails");
        }
        if ((dot = defPersistence.getDataObjectType(name)) == null) {
            throw new ConfigNotFoundException("Data object type '" + name + "' not found.");
        }
        return dot.toAny(returnDetails);
    }

    private String getName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }
}

