/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class JobRunHandler
extends AJobManagerHandler {
    public static final String KEY_SHOW_DETAILS = "returnDetails";

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if (this.isGetRequest(method)) {
            AnyMap outputAny;
            String jobName = this.getJobName(requestUri);
            boolean showDetails = false;
            if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)KEY_SHOW_DETAILS)) {
                showDetails = inputRecord.getMetadata().getBooleanValue(KEY_SHOW_DETAILS);
            }
            if ((outputAny = this.getJobRunDataProvider().getJobRunData(jobName, this.getJobId(requestUri), showDetails)) == null) {
                throw new ConfigNotFoundException("No such job run with name '" + jobName + "'.");
            }
            return outputAny;
        }
        if (this.isDeleteRequest(method)) {
            this.getJobRunEngine().deleteJobRunData(this.getJobName(requestUri), this.getJobId(requestUri));
        }
        return null;
    }

    protected String getJobName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected String getJobId(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 1) {
            return (String)uriParts.get(1);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetOrDeleteRequest(method);
    }
}

