/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomListener
implements TransportListener {
    private static final Log log = LogFactory.getLog((Class)CustomListener.class);
    private int port;
    private String schema;
    private ConfigurationContext axisConf;

    public CustomListener(int port, String schema) {
        this.port = port;
        this.schema = schema;
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        this.axisConf = axisConf;
        Parameter param = transprtIn.getParameter("port");
        if (param != null) {
            this.port = Integer.parseInt((String)param.getValue());
        }
    }

    public void start() throws AxisFault {
    }

    public void stop() throws AxisFault {
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String path = this.axisConf.getServiceContextPath() + "/" + serviceName;
        if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        return new EndpointReference[]{new EndpointReference(this.schema + "://" + ip + ":" + this.port + path + "/")};
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        HttpServletRequest req = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        SessionContext sessionContext = (SessionContext)req.getSession(true).getAttribute("SessionContext");
        String sessionId = null;
        try {
            sessionId = req.getSession().getId();
            if (sessionContext == null) {
                sessionContext = new SessionContext(null);
                sessionContext.setCookieID(sessionId);
                req.getSession().setAttribute("SessionContext", (Object)sessionContext);
            }
        }
        catch (Throwable t) {
            log.info((Object)("Old Servlet API :" + t));
            return null;
        }
        messageContext.setSessionContext(sessionContext);
        messageContext.setProperty("SessionId", sessionId);
        return sessionContext;
    }

    public void destroy() {
    }
}

