/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xpath20;

import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v2.xpath20.WrappedFaultException;
import org.apache.ode.utils.xsd.XSTypes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JaxpVariableResolver
implements XPathVariableResolver {
    private static final Log __log = LogFactory.getLog(JaxpVariableResolver.class);
    private EvaluationContext _ectx;
    private OXPath10ExpressionBPEL20 _oxpath;
    private Configuration _config;

    public JaxpVariableResolver(EvaluationContext evaluationContext, OXPath10ExpressionBPEL20 oXPath10ExpressionBPEL20, Configuration configuration) {
        this._ectx = evaluationContext;
        this._oxpath = oXPath10ExpressionBPEL20;
        this._config = configuration;
    }

    public Object resolveVariable(QName qName) {
        String string;
        String string2;
        __log.debug((Object)("Resolving variable " + qName));
        if (!(this._oxpath instanceof OXPath10ExpressionBPEL20)) {
            throw new IllegalStateException("XPath variables not supported for bpel 1.1");
        }
        if (qName.getNamespaceURI().equals("http://www.apache.org/ode/type/extension") && "pid".equals(qName.getLocalPart())) {
            return this._ectx.getProcessId();
        }
        OXPath10ExpressionBPEL20 oXPath10ExpressionBPEL20 = this._oxpath;
        if (oXPath10ExpressionBPEL20.isJoinExpression) {
            OLink oLink = (OLink)this._oxpath.links.get(qName.getLocalPart());
            try {
                return this._ectx.isLinkActive(oLink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException faultException) {
                throw new WrappedFaultException(faultException);
            }
        }
        int n = qName.getLocalPart().indexOf(46);
        if (n == -1) {
            string2 = qName.getLocalPart();
            string = null;
        } else {
            string2 = qName.getLocalPart().substring(0, n);
            string = qName.getLocalPart().substring(n + 1);
        }
        OScope.Variable variable = (OScope.Variable)this._oxpath.vars.get(string2);
        OMessageVarType.Part part = string == null ? null : ((OMessageVarType)variable.type).parts.get(string);
        try {
            Node node = this._ectx.readVariable(variable, part);
            if (node == null) {
                throw new FaultException(variable.getOwner().constants.qnSelectionFailure, "Unknown variable " + qName.getLocalPart());
            }
            if (this._ectx.narrowTypes()) {
                if (variable.type instanceof OXsdTypeVarType && ((OXsdTypeVarType)variable.type).simple) {
                    return this.getSimpleContent(node, ((OXsdTypeVarType)variable.type).xsdType);
                }
                if (part != null && part.type instanceof OXsdTypeVarType && ((OXsdTypeVarType)part.type).simple) {
                    return this.getSimpleContent(node, ((OXsdTypeVarType)part.type).xsdType);
                }
            }
            return node;
        }
        catch (FaultException faultException) {
            throw new WrappedFaultException(faultException);
        }
    }

    private Object getSimpleContent(Node node, QName qName) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        String string = node.getTextContent();
        try {
            Object object = XSTypes.toJavaObject((QName)qName, (String)string);
            if (object instanceof Calendar) {
                return ((Calendar)object).getTime();
            }
            if (object instanceof String) {
                return document.createTextNode(object.toString());
            }
            return object;
        }
        catch (Exception exception) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    if (node.getParentNode() != null) {
                        return node.getParentNode().getChildNodes();
                    }
                    return document.createTextNode(string);
                }
            }
        }
    }
}

